/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.container.HoneyTankContainer;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyTankTileEntity;
import com.resourcefulbees.resourcefulbees.utils.MathUtils;
import com.resourcefulbees.resourcefulbees.utils.RenderUtils;
import java.text.DecimalFormat;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class HoneyTankScreen
extends ContainerScreen<HoneyTankContainer> {
    HoneyTankTileEntity tileEntity;

    public HoneyTankScreen(HoneyTankContainer container, PlayerInventory inventory, ITextComponent displayName) {
        super((Container)container, inventory, displayName);
        this.tileEntity = container.getHoneyTankTileEntity();
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = new ResourceLocation("resourcefulbees", "textures/gui/honey_tank/honey_tank.png");
        Minecraft client = this.field_230706_i_;
        if (client != null && this.tileEntity != null) {
            client.func_110434_K().func_110577_a(texture);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrix, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
            RenderUtils.renderFluid(matrix, this.tileEntity.getFluidTank(), i + 81, j + 12, 14, 62, this.func_230927_p_());
        }
    }

    private void renderProgressBar(MatrixStack matrix) {
        ResourceLocation texture = new ResourceLocation("resourcefulbees", "textures/gui/honey_tank/honey_tank.png");
        Minecraft client = this.field_230706_i_;
        if (client != null) {
            client.func_110434_K().func_110577_a(texture);
            int i = this.field_147003_i;
            int j = this.field_147009_r;
            this.func_238474_b_(matrix, i + 52, j + 35, 176, 0, 28, (int)(16.0f * this.tileEntity.getProcessEmptyPercent()));
            this.func_238474_b_(matrix, i + 96, j + 35, 176, 16, 28, (int)(16.0f * this.tileEntity.getProcessFillPercent()));
        }
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.tileEntity != null) {
            this.func_230446_a_(matrix);
            super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            this.renderProgressBar(matrix);
            this.func_230459_a_(matrix, mouseX, mouseY);
            DecimalFormat decimalFormat = new DecimalFormat("##0.0");
            if (this.tileEntity.getFluidTank().isEmpty()) {
                return;
            }
            if (MathUtils.inRangeInclusive(mouseX, this.field_147003_i + 81, this.field_147003_i + 93) && MathUtils.inRangeInclusive(mouseY, this.field_147009_r + 12, this.field_147009_r + 74)) {
                LinkedList<IReorderingProcessor> tooltip = new LinkedList<IReorderingProcessor>();
                tooltip.add(new TranslationTextComponent(this.tileEntity.getFluidTank().getFluid().getTranslationKey()).func_241878_f());
                StringTextComponent fluidCount = (float)this.tileEntity.getFluidTank().getFluidAmount() < 1000.0f || Screen.func_231173_s_() ? new StringTextComponent(decimalFormat.format(this.tileEntity.getFluidTank().getFluidAmount()) + " mb") : new StringTextComponent(decimalFormat.format((float)this.tileEntity.getFluidTank().getFluidAmount() / 1000.0f) + " B");
                tooltip.add(fluidCount.func_240699_a_(TextFormatting.GRAY).func_241878_f());
                this.func_238654_b_(matrix, tooltip, mouseX, mouseY);
            }
        }
    }
}

