/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.resourcefulbees.resourcefulbees.block.EnderBeecon;
import com.resourcefulbees.resourcefulbees.client.gui.widget.BeeconEffectWidget;
import com.resourcefulbees.resourcefulbees.client.gui.widget.OptionImageButton;
import com.resourcefulbees.resourcefulbees.container.EnderBeeconContainer;
import com.resourcefulbees.resourcefulbees.lib.TranslationConstants;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.BeeconChangeMessage;
import com.resourcefulbees.resourcefulbees.tileentity.EnderBeeconTileEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.potion.Effect;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class EnderBeeconScreen
extends ContainerScreen<EnderBeeconContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("resourcefulbees", "textures/gui/ender_beecon/ender_beecon.png");
    private final EnderBeeconTileEntity tileEntity;
    private final List<BeeconEffectWidget> powerButtons = new LinkedList<BeeconEffectWidget>();
    private OptionImageButton soundButton;
    private OptionImageButton beamButton;

    public EnderBeeconScreen(EnderBeeconContainer screenContainer, PlayerInventory inventory, ITextComponent titleIn) {
        super((Container)screenContainer, inventory, titleIn);
        this.tileEntity = screenContainer.getEnderBeeconTileEntity();
        this.field_146999_f = 230;
        this.field_147000_g = 200;
        this.field_238744_r_ = 36;
        this.field_238745_s_ = 107;
        this.field_238742_p_ = 110;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        BlockState state = ((EnderBeeconContainer)this.field_147002_h).getEnderBeeconTileEntity().func_195044_w();
        this.soundButton = (OptionImageButton)this.func_230480_a_((Widget)new OptionImageButton(this.field_147003_i + 109, this.field_147009_r + 84, 52, 200, state.func_235901_b_((Property)EnderBeecon.SOUND) && (Boolean)state.func_177229_b((Property)EnderBeecon.SOUND) == false, BACKGROUND){

            @Override
            public void setSelected(boolean selected) {
                super.setSelected(selected);
                NetPacketHandler.sendToServer(new BeeconChangeMessage(BeeconChangeMessage.Option.SOUND, !selected, ((EnderBeeconContainer)EnderBeeconScreen.this.field_147002_h).getEnderBeeconTileEntity().func_174877_v()));
            }
        });
        this.beamButton = (OptionImageButton)this.func_230480_a_((Widget)new OptionImageButton(this.field_147003_i + 132, this.field_147009_r + 84, 92, 200, state.func_235901_b_((Property)EnderBeecon.BEAM) && (Boolean)state.func_177229_b((Property)EnderBeecon.BEAM) == false, BACKGROUND){

            @Override
            public void setSelected(boolean selected) {
                super.setSelected(selected);
                NetPacketHandler.sendToServer(new BeeconChangeMessage(BeeconChangeMessage.Option.BEAM, !selected, ((EnderBeeconContainer)EnderBeeconScreen.this.field_147002_h).getEnderBeeconTileEntity().func_174877_v()));
            }
        });
        this.func_230480_a_((Widget)new RangeSlider(this.field_147003_i + 155, this.field_147009_r + 84, (float)(((EnderBeeconContainer)this.field_147002_h).getEnderBeeconTileEntity().getRange() - 10) / 40.0f));
    }

    protected void func_230450_a_(@NotNull MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        if (this.field_230706_i_ != null && this.tileEntity != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
            this.func_238474_b_(matrix, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            this.func_238474_b_(matrix, this.field_147003_i + 100, this.field_147009_r + 17, 138, 200, 6, 27);
        }
        this.drawButtons();
    }

    private void drawButtons() {
        int buttonStartY = this.field_147009_r + 17;
        this.powerButtons.clear();
        for (Effect allowedEffect : EnderBeeconTileEntity.ALLOWED_EFFECTS) {
            BeeconEffectWidget button = new BeeconEffectWidget(this.field_147003_i + 9, buttonStartY, allowedEffect, ((EnderBeeconContainer)this.field_147002_h).getEnderBeeconTileEntity());
            button.field_230693_o_ = true;
            button.setSelected(this.tileEntity.hasEffect(allowedEffect));
            this.powerButtons.add(button);
            buttonStartY += 22;
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)TranslationConstants.Guis.EnderBeecon.PRIMARY_LABEL, 10.0f, 6.0f, 0x404040);
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TranslationConstants.Guis.EnderBeecon.ACTIVE_LABEL, (int)110, (int)20, (int)0xE0E0E0);
        EnderBeeconScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(this.tileEntity.doEffects() ? "Yes" : "No"), (int)160, (int)20, (int)(this.tileEntity.doEffects() ? 47104 : 0xBC0000));
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TranslationConstants.Guis.EnderBeecon.DRAIN_LABEL, (int)110, (int)32, (int)0xE0E0E0);
        EnderBeeconScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(this.tileEntity.getDrain() + " mb/t"), (int)141, (int)32, (int)16751628);
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TranslationConstants.Guis.EnderBeecon.RANGE_LABEL, (int)110, (int)44, (int)0xE0E0E0);
        EnderBeeconScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(this.tileEntity.getRange() + " blocks"), (int)145, (int)44, (int)34815);
        FluidStack fluidStack = ((EnderBeeconContainer)this.field_147002_h).getEnderBeeconTileEntity().getTank().getFluid();
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TranslationConstants.Guis.EnderBeecon.FLUID_LABEL, (int)110, (int)56, (int)0xE0E0E0);
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)(fluidStack.isEmpty() ? TranslationConstants.Guis.EnderBeecon.NO_FLUID_LABEL : fluidStack.getDisplayName()), (int)137, (int)56, (int)16751628);
        EnderBeeconScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)TranslationConstants.Guis.EnderBeecon.FLUID_AMOUNT_LABEL, (int)110, (int)68, (int)0xE0E0E0);
        EnderBeeconScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)(fluidStack.getAmount() + "mB"), (int)148, (int)68, (int)47104);
    }

    public void func_230430_a_(@NotNull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrix);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrix, mouseX, mouseY);
        for (BeeconEffectWidget widget : this.powerButtons) {
            widget.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
            if (!widget.func_230449_g_()) continue;
            widget.func_230443_a_(matrix, mouseX, mouseY);
        }
        if (this.soundButton.func_230449_g_()) {
            this.soundButton.func_230443_a_(matrix, mouseX, mouseY);
        }
        if (this.beamButton.func_230449_g_()) {
            this.beamButton.func_230443_a_(matrix, mouseX, mouseY);
        }
    }

    public boolean func_231045_a_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return this.func_241217_q_() != null && this.func_231041_ay__() && pButton == 0 ? this.func_241217_q_().func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY) : super.func_231045_a_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (BeeconEffectWidget powerButton : this.powerButtons) {
            powerButton.func_230982_a_(mouseX, mouseY);
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public class RangeSlider
    extends AbstractSlider {
        public RangeSlider(int pX, int pY, double pValue) {
            super(pX, pY, 66, 20, StringTextComponent.field_240750_d_, pValue);
            this.func_230979_b_();
        }

        protected void func_230979_b_() {
            this.func_238482_a_((ITextComponent)new StringTextComponent("Range: " + (int)(this.field_230683_b_ * 40.0 + 10.0)));
        }

        protected void func_230972_a_() {
            int range = (int)(this.field_230683_b_ * 40.0) + 10;
            NetPacketHandler.sendToServer(new BeeconChangeMessage(BeeconChangeMessage.Option.RANGE, range, ((EnderBeeconContainer)EnderBeeconScreen.this.field_147002_h).getEnderBeeconTileEntity().func_174877_v()));
        }
    }
}

