/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.capabilities;

import com.resourcefulbees.resourcefulbees.lib.TagConstants;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class HoneyFluidTank
extends FluidTank {
    private static final Predicate<FluidStack> FLUID_VALIDATOR = fluidStack -> fluidStack.getFluid().func_207185_a(TagConstants.RESOURCEFUL_HONEY);

    public HoneyFluidTank(int capacity) {
        this(capacity, FLUID_VALIDATOR);
    }

    public HoneyFluidTank(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
    }

    public void fillBottle(PlayerEntity player, Hand hand) {
        HoneyFluidTank.fillBottle(this, player, hand);
    }

    public static void fillBottle(FluidTank tank, PlayerEntity player, Hand hand) {
        FluidStack fluidStack = new FluidStack(tank.getFluid(), 250);
        ItemStack itemStack = new ItemStack((IItemProvider)BeeInfoUtils.getHoneyBottleFromFluid(tank.getFluid().getFluid()), 1);
        if (tank.isEmpty()) {
            return;
        }
        if (tank.getFluidAmount() >= 250) {
            tank.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                player.func_191521_c(itemStack);
            } else {
                player.func_184611_a(hand, itemStack);
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void emptyBottle(PlayerEntity player, Hand hand) {
        HoneyFluidTank.emptyBottle(this, player, hand);
    }

    public static void emptyBottle(FluidTank tank, PlayerEntity player, Hand hand) {
        FluidStack fluidStack = new FluidStack(BeeInfoUtils.getHoneyFluidFromBottle(player.func_184586_b(hand)), 250);
        if (!tank.getFluid().isFluidEqual(fluidStack) && !tank.isEmpty()) {
            return;
        }
        if (tank.getFluidAmount() + 250 <= tank.getTankCapacity(0)) {
            tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack stack = player.func_184586_b(hand);
            if (stack.func_190916_E() > 1) {
                stack.func_190920_e(stack.func_190916_E() - 1);
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo, 1));
            } else {
                player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151069_bo, 1));
            }
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

