/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.capabilities;

import com.resourcefulbees.resourcefulbees.api.IBeepediaData;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.network.packets.BeepediaSyncMessage;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeepediaData
implements IBeepediaData {
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("resourcefulbees", "beepedia_data");
    private Set<String> bees = new HashSet<String>();

    public static void sync(ServerPlayerEntity player, IBeepediaData data) {
        NetPacketHandler.sendToPlayer(new BeepediaSyncMessage((CompoundNBT)data.serializeNBT(), new PacketBuffer(Unpooled.buffer())), player);
    }

    @Override
    public Set<String> getBeeList() {
        return this.bees;
    }

    @Override
    public void setBeeList(Set<String> bees) {
        this.bees = bees;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT list = new ListNBT();
        int i = 0;
        for (String bee : this.bees) {
            list.add(i++, (INBT)StringNBT.func_229705_a_((String)bee));
        }
        nbt.func_218657_a("BeepediaData", (INBT)list);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.bees = new HashSet<String>();
        nbt.func_150295_c("BeepediaData", 8).forEach(i -> this.bees.add(i.func_150285_a_()));
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IBeepediaData.class, (Capability.IStorage)new Capability.IStorage<IBeepediaData>(){

            @Nullable
            public INBT writeNBT(Capability<IBeepediaData> capability, IBeepediaData instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<IBeepediaData> capability, IBeepediaData instance, Direction side, INBT nbt) {
                if (nbt instanceof CompoundNBT) {
                    instance.deserializeNBT((INBT)((CompoundNBT)nbt));
                }
            }
        }, BeepediaData::new);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT>,
    ICapabilityProvider {
        @CapabilityInject(value=IBeepediaData.class)
        public static Capability<IBeepediaData> BEEPEDIA_DATA = null;
        private LazyOptional<IBeepediaData> instance = LazyOptional.of(() -> BEEPEDIA_DATA.getDefaultInstance());

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return BEEPEDIA_DATA.orEmpty(cap, this.instance);
        }

        public CompoundNBT serializeNBT() {
            return (CompoundNBT)BEEPEDIA_DATA.getStorage().writeNBT(BEEPEDIA_DATA, this.instance.orElseThrow(() -> new IllegalArgumentException("Could not Serialize BeepediaData.")), null);
        }

        public void deserializeNBT(CompoundNBT nbt) {
            BEEPEDIA_DATA.getStorage().readNBT(BEEPEDIA_DATA, this.instance.orElseThrow(() -> new IllegalArgumentException("Could not Deserialize BeepediaData.")), null, (INBT)nbt);
        }

        public void invalidate() {
            this.instance.invalidate();
        }
    }
}

