/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block.multiblocks.apiary;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.tileentity.multiblocks.apiary.ApiaryTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApiaryBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty VALIDATED = BooleanProperty.func_177716_a((String)"validated");
    private final int tier;

    public ApiaryBlock(int tier, float hardness, float resistance) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(hardness, resistance).func_200947_a(SoundType.field_185852_e));
        this.tier = tier;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)VALIDATED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand handIn, @NotNull BlockRayTraceResult hit) {
        if (!player.func_225608_bj_() && !world.field_72995_K) {
            INamedContainerProvider blockEntity = state.func_215699_b(world, pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)blockEntity, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{VALIDATED, FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ApiaryTileEntity();
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@NotNull BlockState state, World worldIn, @NotNull BlockPos pos) {
        return (INamedContainerProvider)worldIn.func_175625_s(pos);
    }

    public void func_180633_a(World worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof ApiaryTileEntity) {
            ApiaryTileEntity apiaryTileEntity = (ApiaryTileEntity)tile;
            apiaryTileEntity.setTier(this.tier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            int outputQuantity;
            ApiaryOutput outputTypeEnum;
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.beehive.tooltip.max_bees", (Object[])new Object[0])).appendText(" " + Config.APIARY_MAX_BEES.get()).appendText(" " + I18n.func_135052_a((String)"block.resourcefulbees.beehive.tooltip.unique_bees", (Object[])new Object[0]), TextFormatting.BOLD).appendText(TextFormatting.GOLD + " Bees", TextFormatting.RESET).applyStyle(TextFormatting.GOLD).build());
            if (this.tier != 1) {
                int timeReduction = (int)((0.1 + (double)this.tier * 0.05) * 100.0);
                tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.beehive.tooltip.hive_time", (Object[])new Object[0])).appendText(" -" + timeReduction + "%").applyStyle(TextFormatting.GOLD).build());
            }
            switch (this.tier) {
                case 8: {
                    outputTypeEnum = (ApiaryOutput)((Object)Config.T4_APIARY_OUTPUT.get());
                    outputQuantity = (Integer)Config.T4_APIARY_QUANTITY.get();
                    break;
                }
                case 7: {
                    outputTypeEnum = (ApiaryOutput)((Object)Config.T3_APIARY_OUTPUT.get());
                    outputQuantity = (Integer)Config.T3_APIARY_QUANTITY.get();
                    break;
                }
                case 6: {
                    outputTypeEnum = (ApiaryOutput)((Object)Config.T2_APIARY_OUTPUT.get());
                    outputQuantity = (Integer)Config.T2_APIARY_QUANTITY.get();
                    break;
                }
                default: {
                    outputTypeEnum = (ApiaryOutput)((Object)Config.T1_APIARY_OUTPUT.get());
                    outputQuantity = (Integer)Config.T1_APIARY_QUANTITY.get();
                }
            }
            String outputType = outputTypeEnum.equals((Object)ApiaryOutput.COMB) ? I18n.func_135052_a((String)"honeycomb.resourcefulbees", (Object[])new Object[0]) : I18n.func_135052_a((String)"honeycomb_block.resourcefulbees", (Object[])new Object[0]);
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.output_type", (Object[])new Object[0])).appendText(" " + outputType).applyStyle(TextFormatting.GOLD).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.output_quantity", (Object[])new Object[0])).appendText(" " + outputQuantity).applyStyle(TextFormatting.GOLD).build());
        } else if (Screen.func_231172_r_()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.structure_size", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.requisites", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.drops", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.tags", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.offset", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.lock", (Object[])new Object[0]), TextFormatting.AQUA).addTip(I18n.func_135052_a((String)"block.resourcefulbees.apiary.tooltip.lock_2", (Object[])new Object[0]), TextFormatting.AQUA).build());
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"resourcefulbees.shift_info", (Object[])new Object[0])));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.AQUA + I18n.func_135052_a((String)"resourcefulbees.ctrl_info", (Object[])new Object[0])));
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

