/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.container.AutomationSensitiveItemStackHandler;
import com.resourcefulbees.resourcefulbees.tileentity.MechanicalCentrifugeTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MechanicalCentrifugeBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty PROPERTY_ON = BooleanProperty.func_177716_a((String)"on");
    public static final IntegerProperty PROPERTY_ROTATION = IntegerProperty.func_177719_a((String)"rotations", (int)0, (int)7);

    public MechanicalCentrifugeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PROPERTY_ON, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PROPERTY_ROTATION, (Comparable)Integer.valueOf(0)));
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult rayTraceResult) {
        MechanicalCentrifugeTileEntity tile = (MechanicalCentrifugeTileEntity)world.func_175625_s(pos);
        if (player.func_225608_bj_() && !(player instanceof FakePlayer)) {
            if (!world.field_72995_K && tile != null && tile.canProcess(tile.getRecipe())) {
                player.func_71020_j(((Double)Config.PLAYER_EXHAUSTION.get()).floatValue());
                tile.setClicks(tile.getClicks() + 1);
                if ((Integer)state.func_177229_b((Property)PROPERTY_ROTATION) == 7) {
                    world.func_184133_a(null, pos, SoundEvents.field_232731_hu_, SoundCategory.BLOCKS, 0.5f, 0.1f);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187610_bh, SoundCategory.BLOCKS, 0.5f, 0.1f);
                world.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)PROPERTY_ROTATION), 3);
            }
        } else if (!player.func_225608_bj_() && !world.field_72995_K) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tile, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(@NotNull BlockState state, World worldIn, @NotNull BlockPos pos) {
        return (INamedContainerProvider)worldIn.func_175625_s(pos);
    }

    public void func_196243_a(@NotNull BlockState state1, World world, @NotNull BlockPos pos, @NotNull BlockState state, boolean isMoving) {
        TileEntity blockEntity = world.func_175625_s(pos);
        if (blockEntity instanceof MechanicalCentrifugeTileEntity && state.func_177230_c() != state1.func_177230_c()) {
            MechanicalCentrifugeTileEntity centrifugeTileEntity = (MechanicalCentrifugeTileEntity)blockEntity;
            AutomationSensitiveItemStackHandler h = centrifugeTileEntity.getItemStackHandler();
            IntStream.range(0, h.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)h).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).forEach(stack -> InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack));
        }
        super.func_196243_a(state1, world, pos, state, isMoving);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MechanicalCentrifugeTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PROPERTY_ON, PROPERTY_ROTATION, FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)"block.resourcefulbees.mech_centrifuge.tooltip.info", (Object[])new Object[0]), TextFormatting.GOLD).build());
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }
}

