/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.block.CentrifugeBlock;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFlowingFluid;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyTankTileEntity;
import com.resourcefulbees.resourcefulbees.utils.TooltipBuilder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyTank
extends Block {
    protected static final VoxelShape VOXEL_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final AbstractBlock.Properties WOODEN = AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f).harvestTool(ToolType.AXE).func_200943_b(1.0f).func_226896_b_();
    public static final AbstractBlock.Properties PURPUR = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151675_r).func_200947_a(SoundType.field_185853_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200943_b(2.0f).func_226896_b_().func_235861_h_();
    public static final AbstractBlock.Properties NETHER = AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151655_K).func_200947_a(SoundType.field_185853_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200943_b(1.5f).func_226896_b_().func_235861_h_();
    public final HoneyTankTileEntity.TankTier tier;

    public HoneyTank(AbstractBlock.Properties properties, HoneyTankTileEntity.TankTier tier) {
        super(properties);
        this.tier = tier;
        BlockState defaultState = (BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    private static HoneyTankTileEntity getTileEntity(@NotNull IBlockReader world, @NotNull BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof HoneyTankTileEntity) {
            return (HoneyTankTileEntity)entity;
        }
        return null;
    }

    public void func_180655_c(@NotNull BlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        HoneyFlowingFluid fluid;
        HoneyTankTileEntity tank = HoneyTank.getTileEntity((IBlockReader)world, pos);
        if (tank == null) {
            return;
        }
        if (tank.getFluidTank().getFluid().getFluid() instanceof HoneyFlowingFluid && (fluid = (HoneyFlowingFluid)tank.getFluidTank().getFluid().getFluid()).getHoneyData().isRainbow()) {
            world.func_184138_a(pos, stateIn, stateIn, 2);
        }
        super.func_180655_c(stateIn, world, pos, rand);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HoneyTankTileEntity(this.tier);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        boolean usingHoney = heldItem.func_77973_b() instanceof HoneyBottleItem;
        boolean usingBottle = heldItem.func_77973_b() instanceof GlassBottleItem;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof HoneyTankTileEntity) {
            HoneyTankTileEntity tank = (HoneyTankTileEntity)tileEntity;
            if (!world.field_72995_K) {
                if (usingBottle) {
                    tank.fillBottle(player, hand);
                } else if (usingHoney) {
                    tank.emptyBottle(player, hand);
                } else {
                    CentrifugeBlock.capabilityOrGuiUse(tileEntity, player, world, pos, hand);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    @NotNull
    public FluidState func_204507_t(BlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((Property)BlockStateProperties.field_208198_y)) ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public BlockState func_196258_a(@NotNull BlockItemUseContext context) {
        return this.func_176223_P();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return VOXEL_SHAPE;
    }

    @NotNull
    public BlockState func_196271_a(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull IWorld world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (Boolean.TRUE.equals(stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y))) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@NotNull ItemStack stack, @Nullable IBlockReader worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        if (!stack.func_77942_o() || stack.func_77978_p() == null || stack.func_77978_p().isEmpty() || !stack.func_77978_p().func_74764_b("fluid")) {
            return;
        }
        HoneyTankTileEntity.TankTier tankTier = HoneyTankTileEntity.TankTier.getTier(stack.func_77978_p().func_74762_e("tier"));
        FluidTank tank = new FluidTank(tankTier.getMaxFillAmount()).readFromNBT(stack.func_77978_p().func_74775_l("fluid"));
        FluidStack fluid = tank.getFluid();
        if (!fluid.isEmpty()) {
            tooltip.addAll(new TooltipBuilder().addTip(I18n.func_135052_a((String)fluid.getTranslationKey(), (Object[])new Object[0])).appendText(": [" + tank.getFluidAmount() + "/" + tank.getCapacity() + "]").applyStyle(TextFormatting.GOLD).build());
        }
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    public void func_180633_a(World world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable LivingEntity livingEntity, @NotNull ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof HoneyTankTileEntity) {
            HoneyTankTileEntity tank = (HoneyTankTileEntity)tileEntity;
            if (itemStack.func_77978_p() != null) {
                tank.readNBT(itemStack.func_77978_p());
            }
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof HoneyTankTileEntity) {
            HoneyTankTileEntity tank = (HoneyTankTileEntity)tileEntity;
            ItemStack stack = new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
            stack.func_77982_d(tank.writeNBT(new CompoundNBT()));
            return stack;
        }
        return ((Item)this.tier.getTankItem().get()).func_190903_i();
    }

    @NotNull
    public BlockRenderType func_149645_b(@NotNull BlockState blockState) {
        return BlockRenderType.MODEL;
    }
}

