/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import java.util.ArrayList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyPipe
extends Block {
    public static final EnumProperty<PipeState> NORTH = EnumProperty.func_177709_a((String)"north", PipeState.class);
    public static final EnumProperty<PipeState> SOUTH = EnumProperty.func_177709_a((String)"south", PipeState.class);
    public static final EnumProperty<PipeState> EAST = EnumProperty.func_177709_a((String)"east", PipeState.class);
    public static final EnumProperty<PipeState> WEST = EnumProperty.func_177709_a((String)"west", PipeState.class);
    public static final EnumProperty<PipeState> UP = EnumProperty.func_177709_a((String)"up", PipeState.class);
    public static final EnumProperty<PipeState> DOWN = EnumProperty.func_177709_a((String)"down", PipeState.class);
    private static final VoxelShape VOXEL_SHAPE_CENTER = Block.func_208617_a((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape VOXEL_SHAPE_NORTH = Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)7.0);
    private static final VoxelShape VOXEL_SHAPE_EAST = Block.func_208617_a((double)9.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
    private static final VoxelShape VOXEL_SHAPE_SOUTH = Block.func_208617_a((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)11.0, (double)16.0);
    private static final VoxelShape VOXEL_SHAPE_WEST = Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)7.0, (double)11.0, (double)11.0);
    private static final VoxelShape VOXEL_SHAPE_UP = Block.func_208617_a((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape VOXEL_SHAPE_DOWN = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);

    public HoneyPipe(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)((Object)PipeState.OUTPUT))).func_206870_a(SOUTH, (Comparable)((Object)PipeState.OUTPUT))).func_206870_a(EAST, (Comparable)((Object)PipeState.NONE))).func_206870_a(WEST, (Comparable)((Object)PipeState.NONE))).func_206870_a(DOWN, (Comparable)((Object)PipeState.NONE))).func_206870_a(UP, (Comparable)((Object)PipeState.NONE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
        if (state.func_177229_b(NORTH) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_NORTH);
        }
        if (state.func_177229_b(EAST) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_EAST);
        }
        if (state.func_177229_b(SOUTH) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_SOUTH);
        }
        if (state.func_177229_b(WEST) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_WEST);
        }
        if (state.func_177229_b(UP) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_UP);
        }
        if (state.func_177229_b(DOWN) != PipeState.NONE) {
            shapes.add(VOXEL_SHAPE_DOWN);
        }
        return VoxelShapes.func_216384_a((VoxelShape)VOXEL_SHAPE_CENTER, (VoxelShape[])shapes.toArray(new VoxelShape[0]));
    }

    @NotNull
    public BlockState func_196271_a(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull IWorld world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        this.updateNetwork();
        return this.updateState(stateIn, facingPos, world, HoneyPipe.getState(facing), facing.func_176734_d());
    }

    private void updateNetwork() {
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState blockState, @NotNull World world, @NotNull BlockPos blockPos, @NotNull PlayerEntity playerEntity, @NotNull Hand hand, @NotNull BlockRayTraceResult blockRayTraceResult) {
        return super.func_225533_a_(blockState, world, blockPos, playerEntity, hand, blockRayTraceResult);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public static EnumProperty<PipeState> getState(Direction facing) {
        switch (facing) {
            case UP: {
                return UP;
            }
            case DOWN: {
                return DOWN;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return NORTH;
    }

    private boolean canConnect(BlockState state) {
        return state.func_177230_c() instanceof HoneyPipe;
    }

    private boolean isTank(BlockPos facingPos, IWorld world, Direction direction) {
        if (world.func_180495_p(facingPos).func_177230_c() instanceof HoneyPipe) {
            return false;
        }
        TileEntity entity = world.func_175625_s(facingPos);
        return entity != null && entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).isPresent();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockState stateIn = this.func_176223_P();
        BlockPos currentPos = context.func_195995_a();
        return this.updateBlockState((IWorld)world, stateIn, currentPos);
    }

    private BlockState updateBlockState(IWorld world, BlockState stateIn, BlockPos currentPos) {
        stateIn = this.updateState(stateIn, currentPos.func_177984_a(), world, UP, Direction.DOWN);
        stateIn = this.updateState(stateIn, currentPos.func_177977_b(), world, DOWN, Direction.UP);
        stateIn = this.updateState(stateIn, currentPos.func_177974_f(), world, EAST, Direction.WEST);
        stateIn = this.updateState(stateIn, currentPos.func_177976_e(), world, WEST, Direction.EAST);
        stateIn = this.updateState(stateIn, currentPos.func_177968_d(), world, SOUTH, Direction.NORTH);
        stateIn = this.updateState(stateIn, currentPos.func_177978_c(), world, NORTH, Direction.SOUTH);
        return stateIn;
    }

    private BlockState updateState(BlockState stateIn, BlockPos pos, IWorld world, EnumProperty<PipeState> stateProperty, Direction direction) {
        if (this.isTank(pos, world, direction)) {
            if (stateIn.func_177229_b(stateProperty) == PipeState.INPUT) {
                return stateIn;
            }
            return (BlockState)stateIn.func_206870_a(stateProperty, (Comparable)((Object)PipeState.OUTPUT));
        }
        if (this.canConnect(world.func_180495_p(pos))) {
            return (BlockState)stateIn.func_206870_a(stateProperty, (Comparable)((Object)PipeState.CONNECTED));
        }
        return (BlockState)stateIn.func_206870_a(stateProperty, (Comparable)((Object)PipeState.NONE));
    }

    public static enum PipeState implements IStringSerializable
    {
        CONNECTED("connected"),
        OUTPUT("output"),
        INPUT("input"),
        NONE("none");

        private final String name;

        private PipeState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        @NotNull
        public String func_176610_l() {
            return this.name;
        }
    }
}

