/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.block.CentrifugeBlock;
import com.resourcefulbees.resourcefulbees.fluids.HoneyFlowingFluid;
import com.resourcefulbees.resourcefulbees.tileentity.HoneyCongealerTileEntity;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.GlassBottleItem;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HoneyCongealer
extends Block {
    protected static final VoxelShape VOXEL_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public HoneyCongealer(AbstractBlock.Properties properties) {
        super(properties);
    }

    private static HoneyCongealerTileEntity getTileEntity(@NotNull IBlockReader world, @NotNull BlockPos pos) {
        TileEntity entity = world.func_175625_s(pos);
        if (entity instanceof HoneyCongealerTileEntity) {
            return (HoneyCongealerTileEntity)entity;
        }
        return null;
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult blockRayTraceResult) {
        TileEntity tileEntity = world.func_175625_s(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        boolean usingHoney = heldItem.func_77973_b() instanceof HoneyBottleItem;
        boolean usingBottle = heldItem.func_77973_b() instanceof GlassBottleItem;
        if (tileEntity instanceof HoneyCongealerTileEntity) {
            HoneyCongealerTileEntity tank = (HoneyCongealerTileEntity)tileEntity;
            if (!world.field_72995_K) {
                if (usingBottle) {
                    tank.fillBottle(player, hand);
                } else if (usingHoney) {
                    tank.emptyBottle(player, hand);
                } else {
                    CentrifugeBlock.capabilityOrGuiUse(tileEntity, player, world, pos, hand);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }

    public void func_180655_c(@NotNull BlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        HoneyFlowingFluid fluid;
        HoneyCongealerTileEntity tank = HoneyCongealer.getTileEntity((IBlockReader)world, pos);
        if (tank == null) {
            return;
        }
        if (tank.getFluidTank().getFluid().getFluid() instanceof HoneyFlowingFluid && (fluid = (HoneyFlowingFluid)tank.getFluidTank().getFluid().getFluid()).getHoneyData().isRainbow()) {
            world.func_184138_a(pos, stateIn, stateIn, 2);
        }
        super.func_180655_c(stateIn, world, pos, rand);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HoneyCongealerTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return VOXEL_SHAPE;
    }
}

