/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.api.honeydata.HoneyBottleData;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredHoneyBlock
extends BreakableBlock {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected final int color;
    protected final boolean isRainbow;
    protected final HoneyBottleData data;

    public ColoredHoneyBlock(HoneyBottleData honeyData) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151571_B).func_226897_b_(0.4f).func_226898_c_(0.5f).func_226896_b_().func_200947_a(SoundType.field_226947_m_));
        this.color = honeyData.getHoneyColorInt();
        this.isRainbow = honeyData.isRainbow();
        this.data = honeyData;
    }

    public HoneyBottleData getData() {
        return this.data;
    }

    public int getHoneyColor() {
        return this.color;
    }

    public static int getBlockColor(BlockState state, @Nullable IBlockReader world, @Nullable BlockPos pos, int tintIndex) {
        ColoredHoneyBlock honeycombBlock = (ColoredHoneyBlock)state.func_177230_c();
        return honeycombBlock.isRainbow ? RainbowColor.getRGB() : honeycombBlock.getHoneyColor();
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        BlockItem blockItem = (BlockItem)stack.func_77973_b();
        if (!(blockItem.func_179223_d() instanceof ColoredHoneyBlock)) {
            return -1;
        }
        ColoredHoneyBlock honeycombBlock = (ColoredHoneyBlock)blockItem.func_179223_d();
        return honeycombBlock.isRainbow ? RainbowColor.getRGB() : honeycombBlock.getHoneyColor();
    }

    public void func_180655_c(@NotNull BlockState stateIn, @NotNull World world, @NotNull BlockPos pos, @NotNull Random rand) {
        if (this.isRainbow) {
            world.func_184138_a(pos, stateIn, stateIn, 2);
        }
        super.func_180655_c(stateIn, world, pos, rand);
    }

    @NotNull
    public List<ItemStack> func_220076_a(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return Collections.singletonList(this.func_199767_j().func_190903_i());
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.func_199767_j().func_190903_i();
    }

    @NotNull
    public VoxelShape func_220071_b(@NotNull BlockState blockState, @NotNull IBlockReader blockReader, @NotNull BlockPos blockPos, @NotNull ISelectionContext selectionContext) {
        return SHAPE;
    }

    public void func_180658_a(World world, @NotNull BlockPos blockPos, Entity entity, float distance) {
        entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
        if (world.field_72995_K) {
            this.addParticles(entity);
        }
        if (entity.func_225503_b_(distance, 0.2f)) {
            entity.func_184185_a(this.field_149762_H.func_185842_g(), this.field_149762_H.func_185843_a() * 0.5f, this.field_149762_H.func_185847_b() * 0.75f);
        }
    }

    private boolean isSliding(BlockPos pos, Entity entity) {
        if (entity.func_233570_aj_()) {
            return false;
        }
        if (entity.func_226278_cu_() > (double)pos.func_177956_o() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.func_213322_ci().field_72448_b >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)pos.func_177958_n() + 0.5 - entity.func_226277_ct_());
        double d1 = Math.abs((double)pos.func_177952_p() + 0.5 - entity.func_226281_cx_());
        double d2 = 0.4375 + (double)(entity.func_213311_cf() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    public void func_196262_a(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        if (this.isSliding(blockPos, entity)) {
            this.triggerAdvancement(entity, blockPos);
            this.updateSlidingVelocity(entity);
            this.addCollisionEffects(world, entity);
        }
        super.func_196262_a(state, world, blockPos, entity);
    }

    private void triggerAdvancement(Entity entity, BlockPos blockPos) {
        if (entity instanceof ServerPlayerEntity && entity.field_70170_p.func_82737_E() % 20L == 0L) {
            CriteriaTriggers.field_229864_K_.func_227152_a_((ServerPlayerEntity)entity, entity.field_70170_p.func_180495_p(blockPos));
        }
    }

    private void updateSlidingVelocity(Entity entity) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < -0.13) {
            double d0 = -0.05 / vector3d.field_72448_b;
            entity.func_213317_d(new Vector3d(vector3d.field_72450_a * d0, -0.05, vector3d.field_72449_c * d0));
        } else {
            entity.func_213317_d(new Vector3d(vector3d.field_72450_a, -0.05, vector3d.field_72449_c));
        }
        entity.field_70143_R = 0.0f;
    }

    private static boolean hasHoneyBlockEffects(Entity entity) {
        return entity instanceof LivingEntity || entity instanceof AbstractMinecartEntity || entity instanceof TNTEntity || entity instanceof BoatEntity;
    }

    private void addCollisionEffects(World world, Entity entity) {
        if (world.field_73012_v.nextInt(5) == 0 && ColoredHoneyBlock.hasHoneyBlockEffects(entity)) {
            entity.func_184185_a(SoundEvents.field_226139_eT_, 1.0f, 1.0f);
            if (world.field_72995_K) {
                this.addParticles(entity);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void addParticles(Entity entity) {
        BlockParticleData particleData = new BlockParticleData(ParticleTypes.field_197611_d, this.getBlock().func_176223_P());
        for (int i = 0; i < 5; ++i) {
            entity.field_70170_p.func_195594_a((IParticleData)particleData, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }
}

