/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.block;

import com.resourcefulbees.resourcefulbees.tileentity.BottomlessHoneyPotTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.HoneyBottleItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottomlessHoneyPot
extends Block {
    protected static final VoxelShape VOXEL_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BottomlessHoneyPot(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BottomlessHoneyPotTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @NotNull
    public VoxelShape func_220053_a(@NotNull BlockState state, @NotNull IBlockReader worldIn, @NotNull BlockPos pos, @NotNull ISelectionContext context) {
        return VOXEL_SHAPE;
    }

    @NotNull
    public ActionResultType func_225533_a_(@NotNull BlockState state, World world, @NotNull BlockPos pos, @NotNull PlayerEntity player, @NotNull Hand hand, @NotNull BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        boolean usingHoney = heldItem.func_77973_b() instanceof HoneyBottleItem;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BottomlessHoneyPotTileEntity) {
            BottomlessHoneyPotTileEntity tank = (BottomlessHoneyPotTileEntity)tileEntity;
            if (!world.field_72995_K && usingHoney) {
                tank.emptyBottle(player, hand);
                return ActionResultType.SUCCESS;
            }
            if (player.func_184586_b(hand).getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
                tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(iFluidHandler -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (World)world, (BlockPos)pos, null));
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, blockRayTraceResult);
    }
}

