/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.lib.LightLevels;
import java.util.Locale;

public class SpawnData
extends AbstractBeeData {
    private final boolean canSpawnInWorld;
    private final int spawnWeight;
    private final int minGroupSize;
    private final int maxGroupSize;
    private final String biomeWhitelist;
    private final String biomeBlacklist;
    private final LightLevels lightLevel;
    private final int minYLevel;
    private final int maxYLevel;

    private SpawnData(boolean canSpawnInWorld, int spawnWeight, int minGroupSize, int maxGroupSize, String biomeWhitelist, String biomeBlacklist, LightLevels lightLevel, int minYLevel, int maxYLevel) {
        super("SpawnData");
        this.canSpawnInWorld = canSpawnInWorld;
        this.spawnWeight = spawnWeight;
        this.minGroupSize = minGroupSize;
        this.maxGroupSize = maxGroupSize;
        this.biomeWhitelist = biomeWhitelist;
        this.biomeBlacklist = biomeBlacklist;
        this.lightLevel = lightLevel;
        this.minYLevel = minYLevel;
        this.maxYLevel = maxYLevel;
    }

    public boolean canSpawnInWorld() {
        return this.canSpawnInWorld;
    }

    public int getSpawnWeight() {
        return this.spawnWeight <= 0 ? 8 : this.spawnWeight;
    }

    public int getMinGroupSize() {
        return Math.max(this.minGroupSize, 0);
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize <= 0 ? 3 : this.maxGroupSize;
    }

    public String getBiomeWhitelist() {
        return this.biomeWhitelist != null ? this.biomeWhitelist.toLowerCase(Locale.ENGLISH) : "tag:overworld";
    }

    public String getBiomeBlacklist() {
        if (this.biomeBlacklist != null) {
            return this.biomeBlacklist.toLowerCase(Locale.ENGLISH);
        }
        return this.biomeWhitelist.equals("tag:ocean") ? "" : "tag:ocean";
    }

    public LightLevels getLightLevel() {
        return this.lightLevel != null ? this.lightLevel : LightLevels.ANY;
    }

    public int getMinYLevel() {
        return this.minYLevel <= 0 ? 1 : this.minYLevel;
    }

    public int getMaxYLevel() {
        return this.maxYLevel <= 0 ? 256 : this.maxYLevel;
    }

    public static SpawnData createDefault() {
        return new Builder(false).createSpawnData();
    }

    public static class Builder {
        private final boolean canSpawnInWorld;
        private int spawnWeight;
        private int minGroupSize;
        private int maxGroupSize;
        private String biomeWhitelist;
        private String biomeBlacklist;
        private LightLevels lightLevel;
        private int minYLevel;
        private int maxYLevel;

        public Builder(boolean canSpawnInWorld) {
            this.canSpawnInWorld = canSpawnInWorld;
        }

        public Builder setSpawnWeight(int spawnWeight) {
            this.spawnWeight = spawnWeight;
            return this;
        }

        public Builder setMinGroupSize(int minGroupSize) {
            this.minGroupSize = minGroupSize;
            return this;
        }

        public Builder setMaxGroupSize(int maxGroupSize) {
            this.maxGroupSize = maxGroupSize;
            return this;
        }

        public Builder setMinYLevel(int minYLevel) {
            this.minYLevel = minYLevel;
            return this;
        }

        public Builder setMaxYLevel(int maxYLevel) {
            this.maxYLevel = maxYLevel;
            return this;
        }

        public Builder setBiomeWhitelist(String biomeWhitelist) {
            this.biomeWhitelist = biomeWhitelist;
            return this;
        }

        public Builder setBiomeBlacklist(String biomeBlacklist) {
            this.biomeBlacklist = biomeBlacklist;
            return this;
        }

        public Builder setLightLevel(LightLevels lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public SpawnData createSpawnData() {
            return new SpawnData(this.canSpawnInWorld, this.spawnWeight, this.minGroupSize, this.maxGroupSize, this.biomeWhitelist, this.biomeBlacklist, this.lightLevel, this.minYLevel, this.maxYLevel);
        }
    }
}

