/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.api.beedata.BreedData;
import com.resourcefulbees.resourcefulbees.api.beedata.CentrifugeData;
import com.resourcefulbees.resourcefulbees.api.beedata.ColorData;
import com.resourcefulbees.resourcefulbees.api.beedata.CombatData;
import com.resourcefulbees.resourcefulbees.api.beedata.MutationData;
import com.resourcefulbees.resourcefulbees.api.beedata.SpawnData;
import com.resourcefulbees.resourcefulbees.api.beedata.TraitData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.lib.ApiaryOutput;
import com.resourcefulbees.resourcefulbees.lib.BaseModelTypes;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import com.resourcefulbees.resourcefulbees.utils.color.RainbowColor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.RegistryObject;

public class CustomBeeData
extends AbstractBeeData {
    private String flower;
    private String creator;
    private String lore;
    private String loreColor;
    private transient HashSet<Block> blockFlowers;
    private transient ResourceLocation entityFlower;
    private String baseLayerTexture;
    private BaseModelTypes baseModelType;
    private int maxTimeInHive;
    private float sizeModifier;
    private String[] traits;
    private transient String name;
    private boolean hasHoneycomb;
    private Integer auraRange;
    private String customCombDrop;
    private String customCombBlockDrop;
    private transient boolean hasCustomDrop;
    private int[] apiaryOutputAmounts = new int[]{(Integer)Config.T1_APIARY_QUANTITY.get(), (Integer)Config.T2_APIARY_QUANTITY.get(), (Integer)Config.T3_APIARY_QUANTITY.get(), (Integer)Config.T4_APIARY_QUANTITY.get()};
    private ApiaryOutput[] apiaryOutputTypes = BeeInfoUtils.getDefaultApiaryTypes();
    private String honeycombRarity;
    private transient boolean shouldResourcefulBeesDoForgeRegistration;
    private final transient HashMap<String, AbstractBeeData> ADDITIONAL_DATA = new HashMap();
    private BreedData BreedData = null;
    private CentrifugeData CentrifugeData = null;
    private ColorData ColorData = null;
    private CombatData CombatData = null;
    private MutationData MutationData = null;
    private SpawnData SpawnData = null;
    private TraitData TraitData = null;
    private transient Supplier<ItemStack> combSupplier;
    private transient Supplier<ItemStack> combBlockItemSupplier;
    private transient RegistryObject<Item> combRegistryObject;
    private transient RegistryObject<Block> combBlockRegistryObject;
    private transient RegistryObject<Item> combBlockItemRegistryObject;
    private transient RegistryObject<Item> spawnEggItemRegistryObject;
    private transient ResourceLocation entityTypeRegistryID;
    private final transient boolean isEasterEggBee;

    private CustomBeeData() {
        super("CustomBeeData");
        this.isEasterEggBee = false;
    }

    private CustomBeeData(String flower, String baseLayerTexture, BaseModelTypes baseModelType, int maxTimeInHive, float sizeModifier, String[] traits, int[] apiaryOutputAmounts, ApiaryOutput[] apiaryOutputTypes, String name, boolean hasHoneycomb, MutationData mutationData, ColorData colorData, CombatData combatData, CentrifugeData centrifugeData, BreedData breedData, SpawnData spawnData, TraitData traitData, boolean isEasterEggBee, String lore, String loreColor, String creator, String honeycombRarity, boolean hasCustomDrop) {
        super("CustomBeeData");
        this.flower = flower;
        this.baseLayerTexture = baseLayerTexture;
        this.baseModelType = baseModelType;
        this.maxTimeInHive = maxTimeInHive;
        this.sizeModifier = sizeModifier;
        this.traits = traits;
        this.apiaryOutputAmounts = apiaryOutputAmounts;
        this.apiaryOutputTypes = apiaryOutputTypes;
        this.name = name;
        this.hasHoneycomb = hasHoneycomb;
        this.BreedData = breedData;
        this.CentrifugeData = centrifugeData;
        this.ColorData = colorData;
        this.MutationData = mutationData;
        this.SpawnData = spawnData;
        this.TraitData = traitData;
        this.CombatData = combatData;
        this.isEasterEggBee = isEasterEggBee;
        this.lore = lore;
        this.loreColor = loreColor;
        this.creator = creator;
        this.honeycombRarity = honeycombRarity;
        this.hasCustomDrop = hasCustomDrop;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLore() {
        return this.lore;
    }

    public Style getLoreColor() {
        if (this.loreColor != null) {
            Color color = this.loreColor.equals("rainbow") ? Color.func_240743_a_((int)RainbowColor.getRGB()) : Color.func_240745_a_((String)this.loreColor);
            return Style.field_240709_b_.func_240718_a_(color);
        }
        return Style.field_240709_b_.func_240712_a_(TextFormatting.WHITE);
    }

    public boolean isEasterEggBee() {
        return this.isEasterEggBee;
    }

    public String getFlower() {
        return this.flower == null ? "all" : this.flower.toLowerCase(Locale.ENGLISH);
    }

    public ResourceLocation getEntityFlower() {
        return this.entityFlower;
    }

    public boolean hasEntityFlower() {
        return this.entityFlower != null && !this.entityFlower.func_110624_b().isEmpty() && !this.entityFlower.func_110623_a().isEmpty();
    }

    public void setEntityFlower(ResourceLocation entityID) {
        this.entityFlower = entityID;
    }

    public Set<Block> getBlockFlowers() {
        return Collections.unmodifiableSet(this.blockFlowers);
    }

    public boolean hasBlockFlowers() {
        return this.blockFlowers != null && !this.blockFlowers.isEmpty();
    }

    public void addBlockFlower(Block block) {
        if (this.blockFlowers == null) {
            this.blockFlowers = new HashSet();
        }
        this.blockFlowers.add(block);
    }

    public String getCustomCombDrop() {
        return this.customCombDrop;
    }

    public String getCustomCombBlockDrop() {
        return this.customCombBlockDrop;
    }

    public Rarity getHoneycombRarity() {
        return this.honeycombRarity == null ? Rarity.COMMON : Rarity.valueOf((String)this.honeycombRarity.toUpperCase(Locale.ROOT));
    }

    public int[] getApiaryOutputAmounts() {
        return this.apiaryOutputAmounts;
    }

    public ApiaryOutput[] getApiaryOutputsTypes() {
        return this.apiaryOutputTypes != null ? this.apiaryOutputTypes : BeeInfoUtils.getDefaultApiaryTypes();
    }

    public boolean hasCustomDrop() {
        return this.customCombDrop != null && !this.customCombDrop.isEmpty() && this.customCombBlockDrop != null && !this.customCombBlockDrop.isEmpty() || this.hasCustomDrop;
    }

    public boolean hasHoneycomb() {
        return this.hasHoneycomb;
    }

    public String getBaseLayerTexture() {
        if (this.baseLayerTexture != null) {
            return this.baseLayerTexture.startsWith("/") ? this.baseLayerTexture.replaceFirst("/", "").toLowerCase(Locale.ENGLISH) : this.baseLayerTexture.toLowerCase(Locale.ENGLISH);
        }
        return "custom/bee";
    }

    public int getMaxTimeInHive() {
        if (this.maxTimeInHive < 600) {
            return this.maxTimeInHive == 0 ? 2400 : 600;
        }
        return this.maxTimeInHive;
    }

    public RegistryObject<Item> getCombRegistryObject() {
        return this.combRegistryObject;
    }

    public void setCombRegistryObject(RegistryObject<Item> combRegistryObject) {
        this.combRegistryObject = this.combRegistryObject == null ? combRegistryObject : this.combRegistryObject;
    }

    public RegistryObject<Block> getCombBlockRegistryObject() {
        return this.combBlockRegistryObject;
    }

    public void setCombBlockRegistryObject(RegistryObject<Block> combBlockRegistryObject) {
        this.combBlockRegistryObject = this.combBlockRegistryObject == null ? combBlockRegistryObject : this.combBlockRegistryObject;
    }

    public RegistryObject<Item> getCombBlockItemRegistryObject() {
        return this.combBlockItemRegistryObject;
    }

    public void setCombBlockItemRegistryObject(RegistryObject<Item> combBlockItemRegistryObject) {
        this.combBlockItemRegistryObject = this.combBlockItemRegistryObject == null ? combBlockItemRegistryObject : this.combBlockItemRegistryObject;
    }

    public ResourceLocation getEntityTypeRegistryID() {
        return this.entityTypeRegistryID;
    }

    public void setEntityTypeRegistryID(ResourceLocation entityTypeRegistryID) {
        this.entityTypeRegistryID = this.entityTypeRegistryID == null ? entityTypeRegistryID : this.entityTypeRegistryID;
    }

    public RegistryObject<Item> getSpawnEggItemRegistryObject() {
        return this.spawnEggItemRegistryObject;
    }

    public void setSpawnEggItemRegistryObject(RegistryObject<Item> spawnEggItemRegistryObject) {
        this.spawnEggItemRegistryObject = this.spawnEggItemRegistryObject == null ? spawnEggItemRegistryObject : this.spawnEggItemRegistryObject;
    }

    public void setName(String name) {
        this.name = this.name == null ? name : this.name;
    }

    public int getAuraRange() {
        return this.auraRange != null && this.auraRange > 0 ? Math.max(Math.min(this.auraRange, 20), 3) : (Integer)Config.DEFAULT_BEE_AURA_RANGE.get();
    }

    public float getSizeModifier() {
        return this.sizeModifier != 0.0f ? this.sizeModifier : ((Double)Config.BEE_SIZE_MODIFIER.get()).floatValue();
    }

    public String[] getTraitNames() {
        return this.traits;
    }

    public boolean hasTraitNames() {
        return this.traits != null && this.traits.length > 0;
    }

    public String getName() {
        return this.name;
    }

    public void addData(String key, AbstractBeeData data) {
        if (data != null) {
            this.ADDITIONAL_DATA.put(key, data);
        }
    }

    public AbstractBeeData getData(String key) {
        return this.ADDITIONAL_DATA.get(key);
    }

    public boolean containsData(String key) {
        return this.ADDITIONAL_DATA.containsKey(key);
    }

    public BreedData getBreedData() {
        return this.BreedData != null ? this.BreedData : com.resourcefulbees.resourcefulbees.api.beedata.BreedData.createDefault();
    }

    public CentrifugeData getCentrifugeData() {
        return this.CentrifugeData != null ? this.CentrifugeData : com.resourcefulbees.resourcefulbees.api.beedata.CentrifugeData.createDefault();
    }

    public ColorData getColorData() {
        return this.ColorData != null ? this.ColorData : com.resourcefulbees.resourcefulbees.api.beedata.ColorData.createDefault();
    }

    public CombatData getCombatData() {
        return this.CombatData != null ? this.CombatData : com.resourcefulbees.resourcefulbees.api.beedata.CombatData.createDefault();
    }

    public MutationData getMutationData() {
        return this.MutationData != null ? this.MutationData : com.resourcefulbees.resourcefulbees.api.beedata.MutationData.createDefault();
    }

    public SpawnData getSpawnData() {
        return this.SpawnData != null ? this.SpawnData : com.resourcefulbees.resourcefulbees.api.beedata.SpawnData.createDefault();
    }

    public TraitData getTraitData() {
        return this.TraitData != null ? this.TraitData : com.resourcefulbees.resourcefulbees.api.beedata.TraitData.createDefault();
    }

    public void setTraitData(TraitData traitData) {
        this.TraitData = this.TraitData != null ? this.TraitData : traitData;
    }

    public ItemStack getCombStack() {
        return this.combSupplier != null ? this.combSupplier.get() : new ItemStack((IItemProvider)this.getCombRegistryObject().get());
    }

    public ItemStack getCombBlockItemStack() {
        return this.combBlockItemSupplier != null ? this.combBlockItemSupplier.get() : new ItemStack((IItemProvider)this.getCombBlockItemRegistryObject().get());
    }

    public void setCombSupplier(Supplier<ItemStack> combSupplier) {
        this.combSupplier = combSupplier;
    }

    public void setCombBlockItemSupplier(Supplier<ItemStack> combBlockItemSupplier) {
        this.combBlockItemSupplier = combBlockItemSupplier;
    }

    public BaseModelTypes getBaseModelType() {
        return this.baseModelType == null ? BaseModelTypes.DEFAULT : this.baseModelType;
    }

    public TranslationTextComponent getTranslation() {
        return new TranslationTextComponent("entity.resourcefulbees." + this.name + "_bee");
    }

    public boolean shouldResourcefulBeesDoForgeRegistration() {
        return this.shouldResourcefulBeesDoForgeRegistration;
    }

    public void setShouldResourcefulBeesDoForgeRegistration(boolean shouldResourcefulBeesDoForgeRegistration) {
        this.shouldResourcefulBeesDoForgeRegistration = shouldResourcefulBeesDoForgeRegistration;
    }

    public static class Builder {
        private final String flower;
        private String lore;
        private String loreColor;
        private String creator;
        private String baseLayerTexture;
        private BaseModelTypes baseModelType = BaseModelTypes.DEFAULT;
        private int maxTimeInHive;
        private float sizeModifier;
        private String[] traits;
        private int[] apiaryOutputAmounts;
        private final String name;
        private final boolean hasHoneycomb;
        private final MutationData mutationData;
        private final ColorData colorData;
        private final CombatData combatData;
        private final CentrifugeData centrifugeData;
        private final BreedData breedData;
        private final SpawnData spawnData;
        private final TraitData traitData;
        private boolean isEasterEggBee = false;
        private ApiaryOutput[] apiaryOutputTypes = BeeInfoUtils.getDefaultApiaryTypes();
        private String honeycombRarity;
        private boolean hasCustomDrop;

        public Builder(String name, String flower, boolean hasHoneycomb, MutationData mutationData, ColorData colorData, CombatData combatData, CentrifugeData centrifugeData, BreedData breedData, SpawnData spawnData, TraitData traitData) {
            this.name = name;
            this.flower = flower;
            this.hasHoneycomb = hasHoneycomb;
            this.mutationData = mutationData;
            this.colorData = colorData;
            this.combatData = combatData;
            this.centrifugeData = centrifugeData;
            this.breedData = breedData;
            this.spawnData = spawnData;
            this.traitData = traitData;
        }

        public Builder setLore(String lore) {
            this.lore = lore;
            return this;
        }

        public Builder setLoreColor(String loreColor) {
            this.loreColor = loreColor;
            return this;
        }

        public Builder setCreator(String creator) {
            this.creator = creator;
            return this;
        }

        public Builder setApiaryOutputTypes(ApiaryOutput[] outputs) {
            this.apiaryOutputTypes = outputs;
            return this;
        }

        public Builder setEasterEggBee(boolean easterEggBee) {
            this.isEasterEggBee = easterEggBee;
            return this;
        }

        public Builder setBaseLayerTexture(String baseLayerTexture) {
            this.baseLayerTexture = baseLayerTexture;
            return this;
        }

        public Builder setBaseModelType(BaseModelTypes modelType) {
            this.baseModelType = modelType;
            return this;
        }

        public Builder setMaxTimeInHive(int maxTimeInHive) {
            this.maxTimeInHive = maxTimeInHive;
            return this;
        }

        public Builder setSizeModifier(float sizeModifier) {
            this.sizeModifier = sizeModifier;
            return this;
        }

        public Builder setTraits(String[] traits) {
            this.traits = traits;
            return this;
        }

        public Builder setApiaryOutputAmounts(int[] apiaryOutputAmounts) {
            this.apiaryOutputAmounts = apiaryOutputAmounts;
            return this;
        }

        public Builder setHoneycombRarity(String rarity) {
            this.honeycombRarity = rarity;
            return this;
        }

        public Builder hasCustomDrop() {
            this.hasCustomDrop = true;
            return this;
        }

        public CustomBeeData createCustomBee() {
            return new CustomBeeData(this.flower, this.baseLayerTexture, this.baseModelType, this.maxTimeInHive, this.sizeModifier, this.traits, this.apiaryOutputAmounts, this.apiaryOutputTypes, this.name, this.hasHoneycomb, this.mutationData, this.colorData, this.combatData, this.centrifugeData, this.breedData, this.spawnData, this.traitData, this.isEasterEggBee, this.lore, this.loreColor, this.creator, this.honeycombRarity, this.hasCustomDrop);
        }
    }
}

