/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;

public class CombatData
extends AbstractBeeData {
    private Float baseHealth;
    private Float attackDamage;
    private boolean removeStingerOnAttack;
    private boolean isPassive;
    private boolean inflictsPoison;
    private boolean isInvulnerable;

    private CombatData(boolean isPassive, Float attackDamage, boolean removeStingerOnAttack, boolean inflictsPoison, Float baseHealth, boolean isInvulnerable) {
        super("CombatData");
        this.isPassive = isPassive;
        this.attackDamage = attackDamage;
        this.removeStingerOnAttack = removeStingerOnAttack;
        this.inflictsPoison = inflictsPoison;
        this.baseHealth = baseHealth;
        this.isInvulnerable = isInvulnerable;
    }

    public float getBaseHealth() {
        return this.baseHealth == null ? 10.0f : this.baseHealth.floatValue();
    }

    public float getAttackDamage() {
        return this.attackDamage == null ? 1.0f : this.attackDamage.floatValue();
    }

    public boolean removeStingerOnAttack() {
        return this.removeStingerOnAttack;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public boolean inflictsPoison() {
        return this.inflictsPoison;
    }

    public boolean isInvulnerable() {
        return this.isInvulnerable;
    }

    public static CombatData createDefault() {
        return new Builder(false).setRemoveStingerOnAttack(true).setInflictsPoison(true).create();
    }

    public static class Builder {
        private final boolean isPassive;
        private Float baseHealth;
        private Float attackDamage;
        private boolean removeStingerOnAttack;
        private boolean inflictsPoison;
        private boolean isInvulnerable;

        public Builder(boolean isPassive) {
            this.isPassive = isPassive;
        }

        public Builder setAttackDamage(Float attackDamage) {
            this.attackDamage = attackDamage;
            return this;
        }

        public Builder setBaseHealth(Float baseHealth) {
            this.baseHealth = baseHealth;
            return this;
        }

        public Builder setRemoveStingerOnAttack(boolean removeStingerOnAttack) {
            this.removeStingerOnAttack = removeStingerOnAttack;
            return this;
        }

        public Builder setInflictsPoison(boolean inflictsPoison) {
            this.inflictsPoison = inflictsPoison;
            return this;
        }

        public Builder setIsInvulnerable(boolean isInvulnerable) {
            this.isInvulnerable = isInvulnerable;
            return this;
        }

        public CombatData create() {
            return new CombatData(this.isPassive, this.attackDamage, this.removeStingerOnAttack, this.inflictsPoison, this.baseHealth, this.isInvulnerable);
        }
    }
}

