/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.lib.ModelTypes;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class ColorData
extends AbstractBeeData {
    private static final String WHITE = "#ffffff";
    private final String primaryColor;
    private final String secondaryColor;
    private final String honeycombColor;
    private final String primaryLayerTexture;
    private final String secondaryLayerTexture;
    private final String emissiveLayerTexture;
    private final String gelLayerTexture;
    private final boolean isBeeColored;
    private final boolean isRainbowBee;
    private final boolean isGlowing;
    private final String glowColor;
    private final boolean isEnchanted;
    private final int glowingPulse;
    private final ModelTypes modelType;
    private final String modelLocation;

    private ColorData(String primaryColor, String secondaryColor, String honeycombColor, String primaryLayerTexture, String secondaryLayerTexture, String emissiveLayerTexture, String gelLayerTexture, boolean isBeeColored, boolean isRainbowBee, boolean isGlowing, String glowColor, boolean isEnchanted, int glowingPulse, ModelTypes modelType, String modelLocation) {
        super("ColorData");
        this.primaryColor = primaryColor;
        this.secondaryColor = secondaryColor;
        this.honeycombColor = honeycombColor;
        this.primaryLayerTexture = primaryLayerTexture;
        this.secondaryLayerTexture = secondaryLayerTexture;
        this.emissiveLayerTexture = emissiveLayerTexture;
        this.gelLayerTexture = gelLayerTexture;
        this.isBeeColored = isBeeColored;
        this.isRainbowBee = isRainbowBee;
        this.isGlowing = isGlowing;
        this.glowColor = glowColor;
        this.isEnchanted = isEnchanted;
        this.glowingPulse = glowingPulse;
        this.modelType = modelType;
        this.modelLocation = modelLocation;
    }

    public String getPrimaryColor() {
        return this.primaryColor == null ? WHITE : this.primaryColor;
    }

    public String getSecondaryColor() {
        return this.secondaryColor == null ? "#303030" : this.secondaryColor;
    }

    public String getHoneycombColor() {
        return this.honeycombColor == null ? WHITE : this.honeycombColor;
    }

    public String getGlowColor() {
        return this.glowColor == null ? WHITE : this.glowColor;
    }

    public String getPrimaryLayerTexture() {
        if (this.primaryLayerTexture != null) {
            return this.primaryLayerTexture.startsWith("/") ? this.primaryLayerTexture.replaceFirst("/", "").toLowerCase(Locale.ENGLISH) : this.primaryLayerTexture.toLowerCase(Locale.ENGLISH);
        }
        return "custom/primary_layer";
    }

    public String getSecondaryLayerTexture() {
        if (this.secondaryLayerTexture != null) {
            return this.secondaryLayerTexture.startsWith("/") ? this.secondaryLayerTexture.replaceFirst("/", "").toLowerCase(Locale.ENGLISH) : this.secondaryLayerTexture.toLowerCase(Locale.ENGLISH);
        }
        return "custom/secondary_layer";
    }

    public String getEmissiveLayerTexture() {
        if (this.emissiveLayerTexture != null) {
            return this.emissiveLayerTexture.startsWith("/") ? this.emissiveLayerTexture.replaceFirst("/", "").toLowerCase(Locale.ENGLISH) : this.emissiveLayerTexture.toLowerCase(Locale.ENGLISH);
        }
        return "custom/emissive_layer";
    }

    public String getGelLayerTexture() {
        return this.gelLayerTexture.startsWith("/") ? this.gelLayerTexture.replaceFirst("/", "").toLowerCase(Locale.ENGLISH) : this.gelLayerTexture.toLowerCase(Locale.ENGLISH);
    }

    public boolean isBeeColored() {
        return this.isBeeColored;
    }

    public boolean isRainbowBee() {
        return this.isRainbowBee;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public boolean isEnchanted() {
        return this.isEnchanted;
    }

    public boolean hasPrimaryColor() {
        return this.primaryColor != null && !this.primaryColor.isEmpty();
    }

    public boolean hasSecondaryColor() {
        return this.secondaryColor != null && !this.secondaryColor.isEmpty();
    }

    public boolean hasHoneycombColor() {
        return this.honeycombColor != null && !this.honeycombColor.isEmpty();
    }

    public boolean hasGlowColor() {
        return this.glowColor != null && !this.glowColor.isEmpty();
    }

    public int getGlowingPulse() {
        return this.glowingPulse;
    }

    public int getPrimaryColorInt() {
        return com.resourcefulbees.resourcefulbees.utils.color.Color.parseInt(this.getPrimaryColor());
    }

    public int getSecondaryColorInt() {
        return com.resourcefulbees.resourcefulbees.utils.color.Color.parseInt(this.getSecondaryColor());
    }

    public int getHoneycombColorInt() {
        return com.resourcefulbees.resourcefulbees.utils.color.Color.parseInt(this.getHoneycombColor());
    }

    public int getGlowColorInt() {
        return com.resourcefulbees.resourcefulbees.utils.color.Color.parseInt(this.getGlowColor());
    }

    public ModelTypes getModelType() {
        return this.modelType != null ? this.modelType : ModelTypes.DEFAULT;
    }

    public ResourceLocation getModeLocation() {
        if (this.modelLocation != null) {
            return new ResourceLocation(this.modelLocation);
        }
        return this.getModelType().model;
    }

    public float[] getPrimaryColorFloats() {
        return new Color(this.getPrimaryColorInt()).getComponents(null);
    }

    public float[] getSecondaryColorFloats() {
        return new Color(this.getSecondaryColorInt()).getComponents(null);
    }

    public float[] getGlowColorFloats() {
        return new Color(this.getGlowColorInt()).getComponents(null);
    }

    public static ColorData createDefault() {
        return new Builder(false).createColorData();
    }

    public static class Builder {
        private String primaryColor;
        private String secondaryColor;
        private String honeycombColor;
        private String glowColor;
        private String primaryLayerTexture;
        private String secondaryLayerTexture;
        private String emissiveLayerTexture;
        private String gelLayerTexture;
        private final boolean isBeeColored;
        private boolean isRainbowBee;
        private boolean isGlowing;
        private boolean isEnchanted;
        private int glowingPulse;
        private ModelTypes modelType;
        private String modelLocation;

        public Builder(boolean isBeeColored) {
            this.isBeeColored = isBeeColored;
        }

        public Builder setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public Builder setSecondaryColor(String secondaryColor) {
            this.secondaryColor = secondaryColor;
            return this;
        }

        public Builder setHoneycombColor(String honeycombColor) {
            this.honeycombColor = honeycombColor;
            return this;
        }

        public Builder setPrimaryLayerTexture(String primaryLayerTexture) {
            this.primaryLayerTexture = primaryLayerTexture;
            return this;
        }

        public Builder setSecondaryLayerTexture(String secondaryLayerTexture) {
            this.secondaryLayerTexture = secondaryLayerTexture;
            return this;
        }

        public Builder setEmissiveLayerTexture(String emissiveLayerTexture) {
            this.emissiveLayerTexture = emissiveLayerTexture;
            return this;
        }

        public Builder setGelLayerTexture(String gelLayerTexture) {
            this.gelLayerTexture = gelLayerTexture;
            return this;
        }

        public Builder setIsRainbowBee(boolean isRainbowBee) {
            this.isRainbowBee = isRainbowBee;
            return this;
        }

        public Builder setIsGlowing(boolean isGlowing) {
            this.isGlowing = isGlowing;
            return this;
        }

        public Builder setGlowColor(String glowColor) {
            this.glowColor = glowColor;
            return this;
        }

        public Builder setIsEnchanted(boolean isEnchanted) {
            this.isEnchanted = isEnchanted;
            return this;
        }

        public Builder setGlowingPulse(int glowingPulse) {
            this.glowingPulse = glowingPulse;
            return this;
        }

        public Builder setModelType(ModelTypes modelType) {
            this.modelType = modelType;
            return this;
        }

        public Builder setModelLocation(String modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }

        public ColorData createColorData() {
            return new ColorData(this.primaryColor, this.secondaryColor, this.honeycombColor, this.primaryLayerTexture, this.secondaryLayerTexture, this.emissiveLayerTexture, this.gelLayerTexture, this.isBeeColored, this.isRainbowBee, this.isGlowing, this.glowColor, this.isEnchanted, this.glowingPulse, this.modelType, this.modelLocation);
        }
    }
}

