/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees.api.beedata;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.resourcefulbees.resourcefulbees.api.beedata.AbstractBeeData;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import java.util.Objects;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CentrifugeData
extends AbstractBeeData {
    public static final Logger LOGGER = LogManager.getLogger();
    private final String mainOutput;
    private final String secondaryOutput;
    private final String bottleOutput;
    private final String fluidOutput;
    private final float mainOutputWeight;
    private final float secondaryOutputWeight;
    private final float bottleOutputWeight;
    private final float fluidOutputWeight;
    private final int mainOutputCount;
    private final int secondaryOutputCount;
    private final int bottleOutputCount;
    private final int fluidOutputCount;
    private final int mainInputCount;
    private final JsonElement mainNBTData;
    private transient CompoundNBT mainNBT;
    private final JsonElement secondaryNBTData;
    private transient CompoundNBT secondaryNBT;
    private final JsonElement bottleNBTData;
    private transient CompoundNBT bottleNBT;
    private final int recipeTime;
    private boolean hasCentrifugeOutput;
    private final boolean hasFluidOutput;
    private transient boolean mainIsFluidOutput = false;

    public boolean isMainIsFluidOutput() {
        return this.mainIsFluidOutput;
    }

    private CentrifugeData(String mainOutput, String secondaryOutput, String bottleOutput, String fluidOutput, float mainOutputWeight, float secondaryOutputWeight, float bottleOutputWeight, float fluidOutputWeight, int mainOutputCount, int secondaryOutputCount, int bottleOutputCount, int fluidOutputCount, int mainInputCount, CompoundNBT mainNBT, CompoundNBT secondaryNBT, CompoundNBT bottleNBT, boolean hasCentrifugeOutput, int recipeTime, boolean hasFluidOutput) {
        super("CentrifugeData");
        this.mainOutput = mainOutput;
        this.secondaryOutput = secondaryOutput;
        this.bottleOutput = bottleOutput;
        this.mainOutputWeight = mainOutputWeight;
        this.secondaryOutputWeight = secondaryOutputWeight;
        this.bottleOutputWeight = bottleOutputWeight;
        this.fluidOutputWeight = fluidOutputWeight;
        this.mainOutputCount = mainOutputCount;
        this.secondaryOutputCount = secondaryOutputCount;
        this.bottleOutputCount = bottleOutputCount;
        this.mainInputCount = mainInputCount;
        this.fluidOutputCount = fluidOutputCount;
        this.mainNBTData = null;
        this.mainNBT = mainNBT;
        this.secondaryNBT = secondaryNBT;
        this.secondaryNBTData = null;
        this.bottleNBT = bottleNBT;
        this.bottleNBTData = null;
        this.hasCentrifugeOutput = hasCentrifugeOutput;
        this.recipeTime = recipeTime;
        this.hasFluidOutput = hasFluidOutput;
        this.fluidOutput = fluidOutput;
    }

    public String getMainOutput() {
        return this.mainOutput;
    }

    public String getSecondaryOutput() {
        return this.secondaryOutput == null ? ModItems.WAX.getId().toString() : this.secondaryOutput;
    }

    public String getBottleOutput() {
        return this.bottleOutput != null ? this.bottleOutput : Objects.requireNonNull(Items.field_226638_pX_.getRegistryName()).toString();
    }

    public String getFluidOutput() {
        if (this.mainIsFluidOutput) {
            return this.getMainOutput();
        }
        return this.fluidOutput != null ? this.fluidOutput : Fluids.field_204541_a.getRegistryName().toString();
    }

    public float getMainOutputWeight() {
        return this.mainOutputWeight <= 0.0f ? 1.0f : this.mainOutputWeight;
    }

    public float getSecondaryOutputWeight() {
        return this.secondaryOutputWeight <= 0.0f ? 0.5f : this.secondaryOutputWeight;
    }

    public float getBottleOutputWeight() {
        return this.bottleOutputWeight <= 0.0f ? 0.25f : this.bottleOutputWeight;
    }

    public int getMainOutputCount() {
        return Math.max(1, this.mainOutputCount);
    }

    public int getSecondaryOutputCount() {
        return Math.max(1, this.secondaryOutputCount);
    }

    public int getBottleOutputCount() {
        return Math.max(1, this.bottleOutputCount);
    }

    public int getFluidOutputCount() {
        if (this.mainIsFluidOutput) {
            return this.getMainOutputCount() <= 1 ? 250 : this.getMainOutputCount();
        }
        return this.fluidOutputCount <= 1 ? 250 : this.fluidOutputCount;
    }

    public int getMainInputCount() {
        return Math.max(1, this.mainInputCount);
    }

    public boolean hasCentrifugeOutput() {
        return this.hasCentrifugeOutput;
    }

    public void setHasCentrifugeOutput(boolean hasCentrifugeOutput) {
        this.hasCentrifugeOutput = hasCentrifugeOutput;
    }

    public int getRecipeTime() {
        return this.recipeTime > 0 ? this.recipeTime : (Integer)Config.GLOBAL_CENTRIFUGE_RECIPE_TIME.get();
    }

    public boolean hasFluidOutput() {
        return this.hasFluidOutput;
    }

    public CompoundNBT getMainNBT() {
        this.mainNBT = this.getNBT(this.mainNBTData, this.mainNBT);
        return this.mainNBT;
    }

    public CompoundNBT getSecondaryNBT() {
        this.secondaryNBT = this.getNBT(this.secondaryNBTData, this.secondaryNBT);
        return this.secondaryNBT;
    }

    public CompoundNBT getBottleNBT() {
        this.bottleNBT = this.getNBT(this.bottleNBTData, this.bottleNBT);
        return this.bottleNBT;
    }

    private CompoundNBT getNBT(JsonElement nbtData, CompoundNBT nbt) {
        if (nbt == null) {
            nbt = CompoundNBT.field_240597_a_.parse((DynamicOps)JsonOps.INSTANCE, (Object)nbtData).resultOrPartial(e -> {
                if (nbtData != null) {
                    LOGGER.warn("Could not deserialize NBT: [{}]", (Object)nbtData);
                }
            }).orElse(new CompoundNBT());
        }
        if (nbt.isEmpty()) {
            return null;
        }
        return nbt;
    }

    public void init() {
        if (this.hasFluidOutput && this.fluidOutput == null) {
            this.mainIsFluidOutput = true;
        }
    }

    public float getFluidOutputWeight() {
        if (this.mainIsFluidOutput) {
            return this.getMainOutputWeight();
        }
        return this.fluidOutputWeight <= 0.0f ? 1.0f : this.fluidOutputWeight;
    }

    public static CentrifugeData createDefault() {
        return new Builder(false, "minecraft:stone").createCentrifugeData();
    }

    public static class Builder {
        private final String mainOutput;
        private String secondaryOutput;
        private String bottleOutput;
        private String fluidOutput;
        private float mainOutputWeight;
        private float secondaryOutputWeight;
        private float bottleOutputWeight;
        private float fluidOutputWeight;
        private int mainOutputCount;
        private int secondaryOutputCount;
        private int bottleOutputCount;
        private int mainInputCount;
        private int fluidOutputCount;
        private CompoundNBT mainNBT;
        private CompoundNBT secondaryNBT;
        private CompoundNBT bottleNBT;
        private final boolean hasCentrifugeOutput;
        private int recipeTime;
        private boolean hasFluidOutput;

        public Builder setMainNBT(CompoundNBT mainNBT) {
            this.mainNBT = mainNBT;
            return this;
        }

        public Builder setSecondaryNBT(CompoundNBT secondaryNBT) {
            this.secondaryNBT = secondaryNBT;
            return this;
        }

        public Builder setBottleNBT(CompoundNBT bottleNBT) {
            this.bottleNBT = bottleNBT;
            return this;
        }

        public Builder(boolean hasCentrifugeOutput, @Nullable String mainOutput) {
            this.hasCentrifugeOutput = hasCentrifugeOutput;
            this.mainOutput = mainOutput;
        }

        public Builder setSecondaryOutput(String secondaryOutput) {
            this.secondaryOutput = secondaryOutput;
            return this;
        }

        public Builder setBottleOutput(String bottleOutput) {
            this.bottleOutput = bottleOutput;
            return this;
        }

        public Builder setFluidOutputWeight(float fluidOutputWeight) {
            this.fluidOutputWeight = fluidOutputWeight;
            return this;
        }

        public Builder setMainOutputWeight(float mainOutputWeight) {
            this.mainOutputWeight = mainOutputWeight;
            return this;
        }

        public Builder setSecondaryOutputWeight(float secondaryOutputWeight) {
            this.secondaryOutputWeight = secondaryOutputWeight;
            return this;
        }

        public Builder setBottleOutputWeight(float bottleOutputWeight) {
            this.bottleOutputWeight = bottleOutputWeight;
            return this;
        }

        public Builder setMainOutputCount(int mainOutputCount) {
            this.mainOutputCount = mainOutputCount;
            return this;
        }

        public Builder setSecondaryOutputCount(int secondaryOutputCount) {
            this.secondaryOutputCount = secondaryOutputCount;
            return this;
        }

        public Builder setBottleOutputCount(int bottleOutputCount) {
            this.bottleOutputCount = bottleOutputCount;
            return this;
        }

        public Builder setMainInputCount(int mainInputCount) {
            this.mainInputCount = mainInputCount;
            return this;
        }

        public Builder setRecipeTime(int recipeTime) {
            this.recipeTime = recipeTime;
            return this;
        }

        public Builder setHasFluidOutput(boolean hasFluidOutput) {
            this.hasFluidOutput = hasFluidOutput;
            return this;
        }

        public Builder setFluidOutput(String fluidOutput) {
            this.fluidOutput = fluidOutput;
            this.hasFluidOutput = true;
            return this;
        }

        public Builder setFluidOutputCount(int fluidOutputCount) {
            this.fluidOutputCount = fluidOutputCount;
            return this;
        }

        public CentrifugeData createCentrifugeData() {
            return new CentrifugeData(this.mainOutput, this.secondaryOutput, this.bottleOutput, this.fluidOutput, this.mainOutputWeight, this.secondaryOutputWeight, this.bottleOutputWeight, this.fluidOutputWeight, this.mainOutputCount, this.secondaryOutputCount, this.bottleOutputCount, this.fluidOutputCount, this.mainInputCount, this.mainNBT, this.secondaryNBT, this.bottleNBT, this.hasCentrifugeOutput, this.recipeTime, this.hasFluidOutput);
        }
    }
}

