/*
 * Decompiled with CFR 0.152.
 */
package com.resourcefulbees.resourcefulbees;

import com.mojang.brigadier.CommandDispatcher;
import com.resourcefulbees.resourcefulbees.PlayerEvents;
import com.resourcefulbees.resourcefulbees.api.ResourcefulBeesAPI;
import com.resourcefulbees.resourcefulbees.capabilities.BeepediaData;
import com.resourcefulbees.resourcefulbees.client.gui.IncompatibleModWarning;
import com.resourcefulbees.resourcefulbees.client.render.patreon.PetLoader;
import com.resourcefulbees.resourcefulbees.command.BeepediaCommand;
import com.resourcefulbees.resourcefulbees.compat.top.TopCompat;
import com.resourcefulbees.resourcefulbees.config.Config;
import com.resourcefulbees.resourcefulbees.config.ConfigLoader;
import com.resourcefulbees.resourcefulbees.data.DataGen;
import com.resourcefulbees.resourcefulbees.data.RecipeBuilder;
import com.resourcefulbees.resourcefulbees.init.BeeSetup;
import com.resourcefulbees.resourcefulbees.init.BiomeDictionarySetup;
import com.resourcefulbees.resourcefulbees.init.BreedingSetup;
import com.resourcefulbees.resourcefulbees.init.ClientEventHandlers;
import com.resourcefulbees.resourcefulbees.init.FlowerSetup;
import com.resourcefulbees.resourcefulbees.init.ModSetup;
import com.resourcefulbees.resourcefulbees.init.MutationSetup;
import com.resourcefulbees.resourcefulbees.init.TraitSetup;
import com.resourcefulbees.resourcefulbees.item.BeeSpawnEggItem;
import com.resourcefulbees.resourcefulbees.network.NetPacketHandler;
import com.resourcefulbees.resourcefulbees.recipe.HiveIngredient;
import com.resourcefulbees.resourcefulbees.registry.BeeRegistry;
import com.resourcefulbees.resourcefulbees.registry.ModFeatures;
import com.resourcefulbees.resourcefulbees.registry.ModItems;
import com.resourcefulbees.resourcefulbees.registry.ModPotions;
import com.resourcefulbees.resourcefulbees.registry.ModVillagerProfessions;
import com.resourcefulbees.resourcefulbees.registry.RegistryHandler;
import com.resourcefulbees.resourcefulbees.registry.TraitRegistry;
import com.resourcefulbees.resourcefulbees.utils.BeeInfoUtils;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="resourcefulbees")
public class ResourcefulBees {
    public static final String MOD_ID = "resourcefulbees";
    public static final Logger LOGGER = LogManager.getLogger();

    public ResourcefulBees() {
        ModSetup.initialize();
        RegistryHandler.init();
        ResourcefulBeesAPI.setBeeRegistry(BeeRegistry.getRegistry());
        ResourcefulBeesAPI.setTraitRegistry(TraitRegistry.getRegistry());
        BeeRegistry.getRegistry().allowRegistration();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.CommonConfig.COMMON_CONFIG, "resourcefulbees/common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.ClientConfig.CLIENT_CONFIG, "resourcefulbees/client.toml");
        ConfigLoader.load(Config.CommonConfig.COMMON_CONFIG, "resourcefulbees/common.toml");
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> IncompatibleModWarning::init);
        BiomeDictionarySetup.buildDictionary();
        BeeSetup.setupBees();
        RegistryHandler.registerDynamicBees();
        RegistryHandler.registerDynamicHoney();
        if (FMLLoader.isProduction()) {
            Config.GENERATE_DEFAULTS.set((Object)false);
            Config.GENERATE_DEFAULTS.save();
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(RegistryHandler::addEntityAttributes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.LOW, this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onInterModEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setupCommon);
        MinecraftForge.EVENT_BUS.addListener(BeeSetup::onBiomeLoad);
        MinecraftForge.EVENT_BUS.addListener(this::serverLoaded);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommand);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        MinecraftForge.EVENT_BUS.addListener(this::trade);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEventHandlers::clientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemStack stack = new ItemStack((IItemProvider)Items.field_222023_iR);
        stack.func_77982_d(stack.func_196082_o().func_197643_a(new CompoundNBT()));
    }

    private void registerCommand(RegisterCommandsEvent event) {
        BeepediaCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void setupCommon(FMLCommonSetupEvent event) {
        ArgumentTypes.func_218136_a((String)"bee", BeepediaCommand.BeeArgument.class, (IArgumentSerializer)new ArgumentSerializer(BeepediaCommand.BeeArgument::beeArgument));
        ModPotions.createMixes();
    }

    private void serverLoaded(FMLServerStartedEvent event) {
        if (event.getServer().func_71262_S()) {
            MutationSetup.setupMutations();
            FlowerSetup.setupFlowers();
            BreedingSetup.setupFeedItems();
        }
    }

    public void trade(VillagerTradesEvent event) {
        List level1 = (List)event.getTrades().get(1);
        List level2 = (List)event.getTrades().get(2);
        List level3 = (List)event.getTrades().get(3);
        List level4 = (List)event.getTrades().get(4);
        List level5 = (List)event.getTrades().get(5);
        if (event.getType() == ModVillagerProfessions.BEEKEEPER.get()) {
            ItemStack queenBeeBanner = new ItemStack((IItemProvider)Items.field_196206_ev);
            CompoundNBT compoundnbt = queenBeeBanner.func_190925_c("BlockEntityTag");
            ListNBT listnbt = new BannerPattern.Builder().func_222477_a(BannerPattern.RHOMBUS_MIDDLE, DyeColor.LIGHT_BLUE).func_222477_a(BannerPattern.STRIPE_DOWNRIGHT, DyeColor.YELLOW).func_222477_a(BannerPattern.STRIPE_DOWNLEFT, DyeColor.YELLOW).func_222477_a(BannerPattern.STRIPE_BOTTOM, DyeColor.YELLOW).func_222477_a(BannerPattern.TRIANGLE_TOP, DyeColor.YELLOW).func_222477_a(BannerPattern.CURLY_BORDER, DyeColor.YELLOW).func_222476_a();
            compoundnbt.func_218657_a("Patterns", (INBT)listnbt);
            queenBeeBanner.func_200302_a((ITextComponent)new TranslationTextComponent("block.resourcefulbees.queen_bee_banner").func_240699_a_(TextFormatting.GOLD));
            queenBeeBanner.func_190920_e(1);
            level1.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 3), new ItemStack((IItemProvider)ModItems.WAX_BLOCK_ITEM.get(), 1), 32, 4, 1.0f));
            level2.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)Items.field_226635_pU_, 3), 10, 4, 1.0f));
            level3.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 2), new ItemStack((IItemProvider)ModItems.WAX.get(), 6), 15, 4, 1.0f));
            level4.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_226638_pX_, 4), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 10, 4, 0.0f));
            level5.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 12), new ItemStack((IItemProvider)ModItems.SMOKER.get(), 1), 10, 4, 0.0f));
            level5.add((entity, rand) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 64), queenBeeBanner, 2, 4, 0.0f));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        BeepediaData.register();
        BeeInfoUtils.makeValidApiaryTag();
        event.enqueueWork(ModSetup::registerDispenserBehaviors);
        NetPacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new RecipeBuilder());
        ModFeatures.ConfiguredFeatures.registerConfiguredFeatures();
        CraftingHelper.register((ResourceLocation)new ResourceLocation(MOD_ID, "hive"), (IIngredientSerializer)HiveIngredient.Serializer.INSTANCE);
    }

    public void onInterModEnqueue(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TopCompat::new);
        }
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        TraitRegistry.registerDefaultTraits();
        TraitSetup.buildCustomTraits();
        TraitRegistry.setTraitRegistryClosed();
        TraitRegistry.applyBeeTraits();
        BeeSetup.registerBeePlacements();
        BeeSpawnEggItem.initSpawnEggs();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DataGen::generateClientData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> ClientEventHandlers::registerPatreonRender);
        DataGen.generateCommonData();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PetLoader::loadAPI);
    }
}

