/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.entangled.EntangledBlockTile;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class TheOneProbePlugin {
    public static void interModEnqueue(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new ProbeInfoProvider());
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            return null;
        }

        public String getID() {
            return "entangled";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState state, IProbeHitData probeHitData) {
            TileEntity tile = world.func_175625_s(probeHitData.getPos());
            if (tile instanceof EntangledBlockTile) {
                if (((EntangledBlockTile)tile).isBound()) {
                    BlockState boundBlockState = ((EntangledBlockTile)tile).getBoundBlockState();
                    IFormattableTextComponent boundBlock = TextComponents.string((String)TextStyleClass.HIGHLIGHTED.toString()).append(boundBlockState == null ? TextComponents.string((String)"Block").get() : TextComponents.blockState((BlockState)boundBlockState).get()).append(TextComponents.string((String)TextStyleClass.INFO.toString()).get()).get();
                    BlockPos boundPos = ((EntangledBlockTile)tile).getBoundBlockPos();
                    String x = TextStyleClass.HIGHLIGHTED.toString() + boundPos.func_177958_n() + TextStyleClass.INFO;
                    String y = TextStyleClass.HIGHLIGHTED.toString() + boundPos.func_177956_o() + TextStyleClass.INFO;
                    String z = TextStyleClass.HIGHLIGHTED.toString() + boundPos.func_177952_p() + TextStyleClass.INFO;
                    if (((EntangledBlockTile)tile).getBoundDimension() == world.func_234923_W_()) {
                        probeInfo.vertical().text((ITextComponent)TextComponents.translation((String)"entangled.waila.bound_same_dimension", (Object[])new Object[]{boundBlock, x, y, z}).get());
                    } else {
                        String dimension = TextStyleClass.HIGHLIGHTED + TextComponents.dimension(((EntangledBlockTile)tile).getBoundDimension()).format() + TextStyleClass.INFO;
                        probeInfo.vertical().text((ITextComponent)TextComponents.translation((String)"entangled.waila.bound_other_dimension", (Object[])new Object[]{boundBlock, x, y, z, dimension}).get());
                    }
                } else {
                    probeInfo.text((ITextComponent)TextComponents.translation((String)"entangled.waila.unbound").get());
                }
            }
        }
    }
}

