/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.shrink.ShrinkContainer;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.EnergyStorageItemImpl;
import net.gigabit101.shrink.client.KeyBindings;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemShrinkingDevice
extends Item
implements INamedContainerProvider {
    public ItemShrinkingDevice(Item.Properties properties) {
        super(properties.func_208103_a(Rarity.EPIC).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_213453_ef()) {
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (!iShrinkProvider.isShrunk()) {
                    if (!world.func_201670_d()) {
                        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
                    }
                } else if (!world.func_201670_d()) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Can't open while shrunk"), false);
                }
            });
        }
        if (!world.func_201670_d() && player.func_213453_ef()) {
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (!iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.shrink((LivingEntity)((ServerPlayerEntity)player));
                } else if (iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.deShrink((LivingEntity)((ServerPlayerEntity)player));
                } else if (!this.canUse(stack, player) && ((Boolean)ShrinkConfig.POWER_REQUIREMENT.get()).booleanValue()) {
                    player.func_146105_b((ITextComponent)new StringTextComponent("Not enough power in device"), false);
                }
            });
        }
        if (world.func_201670_d() && player.func_213453_ef()) {
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 5.0f, 0.0f);
            this.spawnParticle(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_() - 1.0, world.field_73012_v);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        AtomicReference<Float> scale = new AtomicReference<Float>(Float.valueOf(0.1f));
        player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> scale.set(Float.valueOf(iShrinkProvider.scale())));
        if (entity instanceof LivingEntity && !entity.field_70170_p.field_72995_K) {
            entity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                iShrinkProvider.setScale(((Float)scale.get()).floatValue());
                if (!iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.shrink((LivingEntity)entity);
                } else if (iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.deShrink((LivingEntity)entity);
                }
            });
            return true;
        }
        return false;
    }

    public void spawnParticle(World worldIn, double posX, double posY, double posZ, Random rand) {
        for (int i = 0; i < 16; ++i) {
            int j = rand.nextInt(2) * 2 - 1;
            int k = rand.nextInt(2) * 2 - 1;
            double d0 = posX + 0.5 + 0.25 * (double)j;
            double d1 = (float)posY + rand.nextFloat();
            double d2 = posZ + 0.5 + 0.25 * (double)k;
            double d3 = rand.nextFloat() * (float)j;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.125;
            double d5 = rand.nextFloat() * (float)k;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public boolean canUse(ItemStack stack, PlayerEntity playerEntity) {
        IEnergyStorage energyStorage;
        if (!((Boolean)ShrinkConfig.POWER_REQUIREMENT.get()).booleanValue()) {
            return true;
        }
        if (playerEntity.func_184812_l_()) {
            return true;
        }
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent() && (energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).getEnergyStored() >= (Integer)ShrinkConfig.POWER_COST.get()) {
            energyStorage.extractEnergy(((Integer)ShrinkConfig.POWER_COST.get()).intValue(), false);
            return true;
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == CapabilityEnergy.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageItemImpl(stack, (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get())).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return (Boolean)ShrinkConfig.POWER_REQUIREMENT.get();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - ItemShrinkingDevice.getChargeRatio(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)((1.0f + ItemShrinkingDevice.getChargeRatio(stack)) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(CapabilityEnergy.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        LazyOptional optional;
        if (KeyBindings.shrink != null) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_PURPLE + "Sneak-Click " + TextFormatting.WHITE + "or press " + TextFormatting.DARK_PURPLE + KeyBindings.shrink.getKey().func_237520_d_().getString() + TextFormatting.WHITE + " to active"));
        }
        if ((optional = stack.getCapability(CapabilityEnergy.ENERGY)).isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            tooltip.add((ITextComponent)new StringTextComponent(energyStorage.getEnergyStored() + " FE / " + energyStorage.getMaxEnergyStored() + " FE"));
        }
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_195935_o());
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ShrinkContainer(id, inv);
    }
}

