/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.events;

import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.ShrinkImpl;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.gigabit101.shrink.items.ItemModBottle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="shrink")
public class PlayerEvents {
    @SubscribeEvent
    public static void cloneEvent(PlayerEvent.Clone evt) {
        evt.getOriginal().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(old -> {
            CompoundNBT knowledge = (CompoundNBT)old.serializeNBT();
            evt.getEntityLiving().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.deserializeNBT((INBT)knowledge));
        });
    }

    @SubscribeEvent
    public static void respawnEvent(PlayerEvent.PlayerRespawnEvent evt) {
        evt.getPlayer().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)evt.getPlayer()));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        event.getPlayer().getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)event.getPlayer()));
    }

    @SubscribeEvent
    public static void attachCaps(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof LivingEntity) {
            evt.addCapability(ShrinkImpl.Provider.NAME, (ICapabilityProvider)new ShrinkImpl.Provider((LivingEntity)evt.getObject()));
        }
    }

    @SubscribeEvent
    public static void playerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
        player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(c -> c.sync((LivingEntity)player));
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking event) {
        Entity target = event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (player instanceof ServerPlayerEntity && target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void joinWorldEvent(EntityJoinWorldEvent event) {
        if (!event.getWorld().func_201670_d() && event.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            livingEntity.func_213323_x_();
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> iShrinkProvider.sync(livingEntity));
        }
    }

    @SubscribeEvent
    public static void itemInteractionForEntity(PlayerInteractEvent.EntityInteract event) {
        if (!((Boolean)ShrinkConfig.ENABLE_MOB_BOTTLES.get()).booleanValue()) {
            return;
        }
        if (!event.getWorld().func_201670_d() && event.getTarget() instanceof LivingEntity && !(event.getTarget() instanceof PlayerEntity)) {
            PlayerEntity playerEntity = event.getPlayer();
            if (event.getTarget() instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)event.getTarget();
                if (playerEntity.func_184586_b(event.getHand()).func_77973_b() == Items.field_151069_bo.getItem()) {
                    livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                        if (iShrinkProvider.isShrunk()) {
                            playerEntity.func_184586_b(event.getHand()).func_190918_g(1);
                            ItemStack output = ItemModBottle.setContainedEntity(event.getItemStack(), livingEntity);
                            playerEntity.field_71071_by.func_70441_a(output);
                        }
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public static void changeSize(EntityEvent.Size event) {
        if (event.getEntity() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            livingEntity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                double x = event.getEntity().func_226277_ct_();
                double y = event.getEntity().func_226278_cu_();
                double z = event.getEntity().func_226281_cx_();
                if (iShrinkProvider.isShrunk()) {
                    event.setNewSize(event.getNewSize().func_220313_a(iShrinkProvider.scale()));
                    event.setNewEyeHeight(event.getNewEyeHeight() * iShrinkProvider.scale());
                    event.getEntity().func_70107_b(x, y, z);
                }
            });
        }
    }
}

