/*
 * Decompiled with CFR 0.152.
 */
package com.kotakotik.ponderjs;

import com.kotakotik.ponderjs.PonderJS;
import com.kotakotik.ponderjs.PonderRegistryEventJS;
import com.kotakotik.ponderjs.api.AbstractPonderBuilder;
import com.kotakotik.ponderjs.util.SceneBuilderJS;
import com.kotakotik.ponderjs.util.SceneBuildingUtilJS;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.repack.registrate.util.entry.ItemProviderEntry;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.ListJS;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class PonderBuilderJS
extends AbstractPonderBuilder<ResourceLocation, PonderBuilderJS, SceneConsumer> {
    public static HashMap<String, SceneConsumer> scenes = new HashMap();

    public PonderBuilderJS(String name, ListJS ids) {
        super(PonderJS.appendKubeToId(name), ids.stream().map(Object::toString).map(ResourceLocation::new).collect(Collectors.toList()));
        String namespace = this.name.func_110624_b();
        if (!PonderJS.namespaces.contains(namespace)) {
            PonderJS.namespaces.add(namespace);
        }
    }

    public PonderBuilderJS scene(String name, String displayName, String schematic, SceneConsumer scene) {
        String fullName = this.getName(name);
        if (PonderRegistryEventJS.rerun && !scenes.containsKey(fullName)) {
            ScriptType.CLIENT.console.error((Object)("Tried to register ponder scene " + fullName + " in a reload, you'll have to restart!"));
            return this;
        }
        scenes.put(fullName, scene);
        if (!PonderRegistryEventJS.rerun) {
            String pathOnlyName = this.getPathOnlyName(name);
            Couple sceneId = Couple.create((Object)this.name.func_110624_b(), (Object)pathOnlyName);
            if (!PonderJS.scenes.contains(sceneId)) {
                PonderJS.scenes.add((Couple<String>)sceneId);
            }
            for (ResourceLocation id : this.items) {
                this.addNamedStoryBoard(pathOnlyName, displayName, id, PonderJS.appendKubeToId(schematic), (b, u) -> this.programStoryBoard(fullName, b, u));
            }
        }
        return this;
    }

    @Override
    public PonderBuilderJS getSelf() {
        return this;
    }

    @Override
    protected ResourceLocation[] itemsToIdArray() {
        return this.items.toArray(new ResourceLocation[0]);
    }

    @Override
    protected ItemProviderEntry<?> getItemProviderEntry(ResourceLocation item) {
        return PonderJS.createItemProvider(RegistryObject.of((ResourceLocation)item, (IForgeRegistry)ForgeRegistries.ITEMS));
    }

    @Override
    protected void programStoryBoard(SceneConsumer scene, SceneBuilder builder, SceneBuildingUtil util) {
        scene.accept(new SceneBuilderJS(builder), new SceneBuildingUtilJS(util));
    }

    @Override
    protected void programStoryBoard(String name, SceneBuilder builder, SceneBuildingUtil util) {
        try {
            this.programStoryBoard(scenes.get(name), builder, util);
        }
        catch (Throwable t) {
            t.printStackTrace();
            ScriptType.CLIENT.console.error("Error occurred in ponder " + name, t);
        }
    }

    @Override
    protected String itemToString(ResourceLocation item) {
        return item.toString().replace(":", ".");
    }

    @Override
    protected SceneConsumer createConsumer(BiConsumer<SceneBuilder, SceneBuildingUtil> consumer) {
        return (b, u) -> consumer.accept(b.getInternal(), u.getInternal());
    }

    @Override
    public PonderBuilderJS tag(String ... tags) {
        return (PonderBuilderJS)super.tag(tags);
    }

    @FunctionalInterface
    public static interface SceneConsumer
    extends BiConsumer<SceneBuilderJS, SceneBuildingUtilJS> {
    }
}

