/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.jei;

import java.util.ArrayList;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.jei.LootFabCategory;
import shadows.hostilenetworks.jei.LootFabRecipe;
import shadows.hostilenetworks.jei.SimChamberCategory;
import shadows.hostilenetworks.jei.TickingDataModelWrapper;

@JeiPlugin
public class HostileJeiPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration reg) {
        reg.registerSubtypeInterpreter((Item)Hostile.Items.DATA_MODEL, (IIngredientSubtypeInterpreter)new ModelSubtypes());
        reg.registerSubtypeInterpreter((Item)Hostile.Items.PREDICTION, (IIngredientSubtypeInterpreter)new ModelSubtypes());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new SimChamberCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new LootFabCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        SimChamberCategory.recipes = DataModelManager.INSTANCE.getAllModels().stream().map(TickingDataModelWrapper::new).collect(Collectors.toList());
        reg.addRecipes(SimChamberCategory.recipes, SimChamberCategory.UID);
        ArrayList<LootFabRecipe> fabRecipes = new ArrayList<LootFabRecipe>();
        for (DataModel dm : DataModelManager.INSTANCE.getAllModels()) {
            for (int i = 0; i < dm.getFabDrops().size(); ++i) {
                fabRecipes.add(new LootFabRecipe(dm, i));
            }
        }
        reg.addRecipes(fabRecipes, LootFabCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Hostile.Blocks.SIM_CHAMBER), new ResourceLocation[]{SimChamberCategory.UID});
        reg.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Hostile.Blocks.LOOT_FABRICATOR), new ResourceLocation[]{LootFabCategory.UID});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("hostilenetworks", "plugin");
    }

    private class ModelSubtypes
    implements IIngredientSubtypeInterpreter<ItemStack> {
        private ModelSubtypes() {
        }

        public String apply(ItemStack stack, UidContext context) {
            DataModel dm = DataModelItem.getStoredModel(stack);
            if (dm == null) {
                return "NULL";
            }
            return dm.getId().toString();
        }
    }
}

