/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.util.Color;
import shadows.placebo.util.ClientUtil;

public class DataModelItem
extends Item {
    public static final String DATA_MODEL = "data_model";
    public static final String ID = "id";
    public static final String DATA = "data";
    public static final String ITERATIONS = "iterations";

    public DataModelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public void func_77624_a(ItemStack pStack, World pLevel, List<ITextComponent> list, ITooltipFlag pFlag) {
        if (ClientUtil.isHoldingShift()) {
            DataModel model = DataModelItem.getStoredModel(pStack);
            if (model == null) {
                list.add((ITextComponent)new TranslationTextComponent("Error: %s", new Object[]{new StringTextComponent("Broke_AF").func_240701_a_(new TextFormatting[]{TextFormatting.OBFUSCATED, TextFormatting.GRAY})}));
                return;
            }
            int data = DataModelItem.getData(pStack);
            ModelTier tier = ModelTier.getByData(data);
            list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.tier", new Object[]{tier.getComponent()}));
            int dProg = data - tier.data;
            int dMax = tier.next().data - tier.data;
            if (tier != ModelTier.SELF_AWARE) {
                list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.data", new Object[]{new TranslationTextComponent("hostilenetworks.info.dprog", new Object[]{dProg, dMax}).func_240699_a_(TextFormatting.GRAY)}));
                list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.dpk", new Object[]{new StringTextComponent("" + tier.dataPerKill).func_240699_a_(TextFormatting.GRAY)}));
            }
            list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.sim_cost", new Object[]{new TranslationTextComponent("hostilenetworks.info.rft", new Object[]{model.getSimCost()}).func_240699_a_(TextFormatting.GRAY)}));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("hostilenetworks.info.hold_shift", new Object[]{Color.withColor("hostilenetworks.color_text.shift", TextFormatting.WHITE.func_211163_e())}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_150895_a(ItemGroup pGroup, NonNullList<ItemStack> pItems) {
        if (this.func_194125_a(pGroup)) {
            for (DataModel model : DataModelManager.INSTANCE.getAllModels()) {
                ItemStack s = new ItemStack((IItemProvider)this);
                DataModelItem.setStoredModel(s, model);
                pItems.add((Object)s);
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack pStack) {
        DataModel model = DataModelItem.getStoredModel(pStack);
        Object modelName = model == null ? new StringTextComponent("BROKEN").func_240699_a_(TextFormatting.OBFUSCATED) : model.getName();
        return new TranslationTextComponent(this.func_77667_c(pStack), new Object[]{modelName});
    }

    @Nullable
    public static DataModel getStoredModel(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String dmKey = stack.func_190925_c(DATA_MODEL).func_74779_i(ID);
        return DataModelManager.INSTANCE.getModel(new ResourceLocation(dmKey));
    }

    public static void setStoredModel(ItemStack stack, DataModel model) {
        stack.func_196083_e(DATA_MODEL);
        stack.func_190925_c(DATA_MODEL).func_74778_a(ID, model.getId().toString());
    }

    public static int getData(ItemStack stack) {
        return stack.func_190925_c(DATA_MODEL).func_74762_e(DATA);
    }

    public static void setData(ItemStack stack, int data) {
        stack.func_190925_c(DATA_MODEL).func_74768_a(DATA, data);
    }

    public static int getIters(ItemStack stack) {
        return stack.func_190925_c(DATA_MODEL).func_74762_e(ITERATIONS);
    }

    public static void setIters(ItemStack stack, int data) {
        stack.func_190925_c(DATA_MODEL).func_74768_a(ITERATIONS, data);
    }

    public static boolean matchesInput(ItemStack model, ItemStack stack) {
        boolean item;
        DataModel dModel = DataModelItem.getStoredModel(model);
        if (dModel == null) {
            return false;
        }
        ItemStack input = dModel.getInput();
        boolean bl = item = input.func_77973_b() == stack.func_77973_b();
        if (input.func_77942_o()) {
            if (stack.func_77942_o()) {
                CompoundNBT t1 = input.func_77978_p();
                CompoundNBT t2 = stack.func_77978_p();
                for (String s : t1.func_150296_c()) {
                    if (t1.func_74781_a(s).equals(t2.func_74781_a(s))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return item;
    }
}

