/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.client.WrappedRTBuffer;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.gui.DeepLearnerContainer;
import shadows.hostilenetworks.util.ReflectionThings;
import shadows.hostilenetworks.util.TickableText;

public class DeepLearnerScreen
extends ContainerScreen<DeepLearnerContainer> {
    public static final int WIDTH = 338;
    public static final int HEIGHT = 235;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/deep_learner.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private List<TickableText> texts = new ArrayList<TickableText>();
    private TickableText stats = new TickableText(I18n.func_135052_a((String)"hostilenetworks.gui.stats", (Object[])new Object[0]), 6478079);
    private final String[] statArray = new String[3];
    private int numModels = 0;
    private boolean emptyText = true;
    private CachedModel[] models = new CachedModel[4];
    private int spin = 0;
    private int selectedModel = 0;
    private static DecimalFormat fmt = new DecimalFormat("##.##%");

    public DeepLearnerScreen(DeepLearnerContainer pMenu, PlayerInventory pPlayerInventory, ITextComponent pTitle) {
        super((Container)pMenu, pPlayerInventory, pTitle);
        this.field_146999_f = 338;
        this.field_147000_g = 235;
        this.setupEmptyText();
        pMenu.setNotifyCallback(slotId -> {
            ItemStack stack = pMenu.func_75139_a((int)slotId).func_75211_c();
            CachedModel old = this.models[slotId];
            CachedModel cachedModel = this.models[slotId.intValue()] = stack.func_190926_b() ? null : new CachedModel(stack, (int)slotId);
            if (old == null && this.models[slotId] != null) {
                if (++this.numModels == 1) {
                    this.selectedModel = slotId;
                    this.setupModel(this.models[this.selectedModel]);
                    this.emptyText = false;
                }
            } else if (old != null && this.models[slotId] == null) {
                --this.numModels;
                if (this.numModels > 0 && slotId == this.selectedModel) {
                    this.selectLeft();
                }
            } else if (slotId == this.selectedModel && this.models[this.selectedModel] != null) {
                this.setupModel(this.models[this.selectedModel]);
            }
        });
    }

    public void func_231158_b_(Minecraft pMinecraft, int pWidth, int pHeight) {
        super.func_231158_b_(pMinecraft, pWidth, pHeight);
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() - 27, this.getGuiTop() + 105, 24, 24, 84, 140, 24, BASE, btn -> this.selectLeft()));
        this.func_230480_a_((Widget)new ImageButton(this.getGuiLeft() - 1, this.getGuiTop() + 105, 24, 24, 108, 140, 24, BASE, btn -> this.selectRight()));
    }

    public void selectLeft() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        CachedModel model = this.models[this.clamp(this.selectedModel - 1)];
        while (model == null) {
            model = this.models[this.clamp(this.selectedModel - 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    public void selectRight() {
        if (this.numModels == 0) {
            return;
        }
        int old = this.selectedModel;
        CachedModel model = this.models[this.clamp(this.selectedModel + 1)];
        while (model == null) {
            model = this.models[this.clamp(this.selectedModel + 1)];
        }
        if (model.getSlot() != old) {
            this.setupModel(model);
        }
    }

    private int clamp(int idx) {
        if (idx == -1) {
            idx = 3;
        }
        if (idx == 4) {
            idx = 0;
        }
        this.selectedModel = idx;
        return this.selectedModel;
    }

    public void func_230430_a_(MatrixStack stack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, pMouseX, pMouseY, pPartialTicks);
        this.func_230459_a_(stack, pMouseX, pMouseY);
    }

    protected void func_230450_a_(MatrixStack matrix, float pPartialTicks, int pX, int pY) {
        this.getMinecraft().func_110434_K().func_110577_a(BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.func_238474_b_(matrix, left + 41, top, 0, 0, 256, 140);
        if (this.numModels > 0) {
            for (int i = 0; i < 3; ++i) {
                int n = left + 338 - 49 - this.stats.getWidth(this.field_230712_o_);
                this.field_230712_o_.getClass();
                this.field_230712_o_.getClass();
                this.func_238474_b_(matrix, n, top + 8 + 9 + (9 + 2) * i, 0, 140 + 9 * i, 9, 9);
            }
            this.func_238474_b_(matrix, left - 41, top, 9, 140, 75, 101);
            LivingEntity ent = this.models[this.selectedModel].getEntity((World)this.field_230706_i_.field_71441_e);
            ent.field_70761_aq = this.spin % 360;
            this.renderEntityInInventory(left - 4, top + 90, 40.0f, 0.0f, 0.0f, ent);
            for (int i = 0; i < 3; ++i) {
                String string = this.statArray[i];
                float f = left + 338 - 36 - this.stats.getWidth(this.field_230712_o_);
                this.field_230712_o_.getClass();
                this.field_230712_o_.getClass();
                this.field_230712_o_.func_238421_b_(matrix, string, f, (float)(top + 9 + 9 + (9 + 2) * i), 0xFFFFFF);
            }
        }
        this.getMinecraft().func_110434_K().func_110577_a(PLAYER);
        this.func_238474_b_(matrix, left + 81, top + 145, 0, 0, 176, 90);
        if (this.numModels <= 1) {
            ((Widget)this.field_230710_m_.get((int)0)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = false;
        } else {
            ((Widget)this.field_230710_m_.get((int)0)).field_230694_p_ = true;
            ((Widget)this.field_230710_m_.get((int)1)).field_230694_p_ = true;
        }
    }

    protected void func_230451_b_(MatrixStack stack, int pX, int pY) {
        int left = 49;
        int top = 6;
        this.field_230712_o_.getClass();
        int spacing = 9 + 3;
        int idx = 0;
        for (TickableText t : this.texts) {
            t.render(this.field_230712_o_, stack, left, top + spacing * idx);
            if (t.causesNewLine()) {
                ++idx;
                left = 49;
                continue;
            }
            left += t.getWidth(this.field_230712_o_);
        }
        if (this.numModels > 0) {
            this.stats.render(this.field_230712_o_, stack, 289 - this.stats.getWidth(this.field_230712_o_), top);
        }
    }

    public void func_231023_e_() {
        int i;
        block4: {
            block3: {
                super.func_231023_e_();
                if (((DeepLearnerContainer)this.field_147002_h).hasModels()) break block3;
                if (this.emptyText) break block4;
                this.setupEmptyText();
                this.emptyText = true;
                break block4;
            }
            if (this.emptyText) {
                for (i = 0; i < 4; ++i) {
                    if (this.models[i] == null) continue;
                    this.setupModel(this.models[i]);
                    this.selectedModel = i;
                    this.emptyText = false;
                    break;
                }
            }
        }
        for (i = 0; i < this.texts.size(); ++i) {
            TickableText txt = this.texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
        this.stats.tick();
        ++this.spin;
    }

    private void setupEmptyText() {
        this.resetText();
        for (int i = 0; i < 7; ++i) {
            this.addText(I18n.func_135052_a((String)("hostilenetworks.gui.learner_empty." + i), (Object[])new Object[0]), i == 0 ? 6478079 : 0xFFFFFF);
        }
    }

    private void setupModel(CachedModel cache) {
        int i;
        DataModel model = cache.getModel();
        if (model == null) {
            return;
        }
        this.resetText();
        this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.name", (Object[])new Object[0]), 6478079);
        this.addText(model.getName().getString(), 0xFFFFFF);
        this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.info", (Object[])new Object[0]), 6478079);
        String[] trivia = I18n.func_135052_a((String)model.getTriviaKey(), (Object[])new Object[0]).split("\\n");
        for (i = 0; i < Math.min(4, trivia.length); ++i) {
            this.addText(trivia[i], 0xFFFFFF);
        }
        for (i = trivia.length; i < 5; ++i) {
            this.addText("", 0);
        }
        this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.tier", (Object[])new Object[0]), 0xFFFFFF, false);
        ModelTier tier = cache.getTier();
        ModelTier next = tier.next();
        this.addText(I18n.func_135052_a((String)("hostilenetworks.tier." + tier.name), (Object[])new Object[0]), tier.color.func_211163_e());
        this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.accuracy", (Object[])new Object[0]), 0xFFFFFF, false);
        this.addText(fmt.format(cache.getAccuracy()), tier.color.func_211163_e());
        if (tier != next) {
            this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.next_tier", (Object[])new Object[0]), 0xFFFFFF, false);
            this.addText(I18n.func_135052_a((String)("hostilenetworks.tier." + next.name), (Object[])new Object[0]), next.color.func_211163_e(), false);
            this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.next_tier2", (Object[])new Object[]{cache.getKillsNeeded()}), 0xFFFFFF, false);
            this.addText(I18n.func_135052_a((String)("hostilenetworks.gui.kill" + (cache.getKillsNeeded() > 1 ? "s" : "")), (Object[])new Object[0]), 0xFFFFFF);
        } else {
            this.addText(I18n.func_135052_a((String)"hostilenetworks.gui.max_tier", (Object[])new Object[0]), TextFormatting.RED.func_211163_e());
        }
        LivingEntity ent = cache.getEntity((World)this.field_230706_i_.field_71441_e);
        if (ent == null) {
            for (int i2 = 0; i2 < 3; ++i2) {
                this.statArray[i2] = "\u00a7k99999";
            }
        }
        this.statArray[0] = String.valueOf((int)(ent.func_110148_a(Attributes.field_233818_a_).func_111125_b() / 2.0));
        this.statArray[1] = String.valueOf((int)(ent.func_110148_a(Attributes.field_233826_i_).func_111125_b() / 2.0));
        this.statArray[2] = String.valueOf(ReflectionThings.getExperienceReward(ent, this.field_213127_e.field_70458_d));
    }

    private void addText(String msg, int color) {
        this.texts.add(new TickableText(msg, color, true, 2.0f));
    }

    private void addText(String msg, int color, boolean newline) {
        this.texts.add(new TickableText(msg, color, newline, 2.0f));
    }

    private void resetText() {
        this.texts.clear();
        this.stats.reset();
    }

    public void renderEntityInInventory(float pPosX, float pPosY, float pScale, float pMouseX, float pMouseY, LivingEntity pLivingEntity) {
        float f1 = (float)Math.atan(pMouseY / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)pPosX, (float)pPosY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        DataModel model = this.models[this.selectedModel].getModel();
        matrixstack.func_227862_a_(pScale *= model.getScale(), pScale, pScale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)this.spin + this.field_230706_i_.func_193989_ak()) * 2.25f % 360.0f));
        pLivingEntity.field_70761_aq = pLivingEntity.field_70177_z = 0.0f;
        pLivingEntity.field_70759_as = pLivingEntity.field_70177_z;
        pLivingEntity.field_70758_at = pLivingEntity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl rtBuffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        WeirdRenderThings.fullbright = true;
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_((Entity)pLivingEntity, (double)model.getXOffset(), (double)model.getYOffset(), (double)model.getZOffset(), 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)new WrappedRTBuffer((IRenderTypeBuffer)rtBuffer), 0xF000F0));
        rtBuffer.func_228461_a_();
        WeirdRenderThings.fullbright = false;
        entityrenderermanager.func_178633_a(true);
        RenderSystem.popMatrix();
    }
}

