/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DataModelItem;

public class CachedModel {
    protected final ItemStack stack;
    protected final int slot;
    protected final DataModel model;
    protected int data;
    protected ModelTier tier;
    private Entity cachedEntity;

    public CachedModel(ItemStack stack, int slot) {
        this.stack = stack;
        this.slot = slot;
        this.model = DataModelItem.getStoredModel(stack);
        this.data = DataModelItem.getData(stack);
        this.tier = ModelTier.getByData(this.data);
    }

    public DataModel getModel() {
        return this.model;
    }

    public int getData() {
        return this.data;
    }

    public ModelTier getTier() {
        return this.tier;
    }

    public void setData(int data) {
        this.data = data;
        if (this.data > this.tier.next().data) {
            this.tier = this.tier.next();
        }
        DataModelItem.setData(this.stack, data);
    }

    public int getSlot() {
        return this.slot;
    }

    public float getAccuracy() {
        ModelTier next = this.tier.next();
        if (this.tier == next) {
            return next.accuracy;
        }
        int diff = next.data - this.tier.data;
        float tDiff = next.accuracy - this.tier.accuracy;
        return this.tier.accuracy + tDiff * (float)(diff - (next.data - this.data)) / (float)diff;
    }

    public int getKillsNeeded() {
        ModelTier next = this.tier.next();
        return MathHelper.func_76123_f((float)((float)(next.data - this.data) / (float)this.tier.dataPerKill));
    }

    public LivingEntity getEntity(World world) {
        if (this.cachedEntity == null) {
            this.cachedEntity = this.model.type.func_200721_a(world);
        }
        return this.cachedEntity instanceof LivingEntity ? (LivingEntity)this.cachedEntity : null;
    }

    public ItemStack getPredictionDrop() {
        return this.model.getPredictionDrop();
    }

    public ItemStack getSourceStack() {
        return this.stack;
    }
}

