/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.client.WeirdRenderThings;
import shadows.hostilenetworks.data.CachedModel;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DeepLearnerItem;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="hostilenetworks")
public class DeepLearnerHudRenderer {
    private static final ResourceLocation DL_HUD = new ResourceLocation("hostilenetworks", "textures/gui/deep_learner_hud.png");

    @SubscribeEvent
    public static void render(RenderGameOverlayEvent.Post e) {
        CachedModel cModel;
        int i;
        if (e.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || !(mc.field_71462_r instanceof ChatScreen) && mc.field_71462_r != null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != Hostile.Items.DEEP_LEARNER) {
            stack = player.func_184592_cb();
        }
        if (stack.func_77973_b() != Hostile.Items.DEEP_LEARNER) {
            return;
        }
        ItemStackHandler inv = DeepLearnerItem.getItemHandler(stack);
        ArrayList<Pair> renderable = new ArrayList<Pair>(4);
        for (int i2 = 0; i2 < 4; ++i2) {
            CachedModel cModel2;
            ItemStack model = inv.getStackInSlot(i2);
            if (model.func_190926_b() || (cModel2 = new CachedModel(model, 0)).getModel() == null) continue;
            renderable.add(Pair.of((Object)cModel2, (Object)model));
        }
        if (renderable.isEmpty()) {
            return;
        }
        int spacing = 28;
        int x = 6;
        int y = 6;
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.func_228547_a_();
        mc.func_110434_K().func_110577_a(DL_HUD);
        AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)3, (int)3, (float)0.0f, (float)23.0f, (int)113, (int)1, (int)256, (int)256);
        for (i = 0; i < renderable.size(); ++i) {
            AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)3, (int)(4 + spacing * i), (float)0.0f, (float)24.0f, (int)113, (int)spacing, (int)256, (int)256);
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)(x + 18), (int)(y + i * spacing + 10), (float)0.0f, (float)0.0f, (int)89, (int)12, (int)256, (int)256);
            int width = 87;
            if (cModel.getTier() != ModelTier.SELF_AWARE) {
                int prev = cModel.getTier().data;
                width = MathHelper.func_76123_f((float)((float)(width * (cModel.getData() - prev)) / (float)(cModel.getTier().next().data - prev)));
            }
            AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)(x + 19), (int)(y + i * spacing + 11), (float)0.0f, (float)12.0f, (int)width, (int)10, (int)256, (int)256);
        }
        AbstractGui.func_238463_a_((MatrixStack)e.getMatrixStack(), (int)3, (int)(4 + spacing * renderable.size()), (float)0.0f, (float)122.0f, (int)113, (int)2, (int)256, (int)256);
        WeirdRenderThings.TRANSLUCENT_TRANSPARENCY.func_228549_b_();
        for (i = 0; i < renderable.size(); ++i) {
            ItemStack dModel = (ItemStack)((Pair)renderable.get(i)).getRight();
            mc.func_175599_af().func_180450_b(dModel, x, y + i * spacing + 9);
        }
        for (i = 0; i < renderable.size(); ++i) {
            cModel = (CachedModel)((Pair)renderable.get(i)).getLeft();
            ITextComponent comp = cModel.getTier().getComponent();
            mc.field_71466_p.func_243246_a(e.getMatrixStack(), comp, (float)(x + 4), (float)(y + spacing * i), 0xFFFFFF);
            mc.field_71466_p.func_243246_a(e.getMatrixStack(), (ITextComponent)new TranslationTextComponent("hostilenetworks.hud.model"), (float)(x + mc.field_71466_p.func_238414_a_((ITextProperties)comp) + 4), (float)(y + spacing * i), 0xFFFFFF);
            if (cModel.getTier() == ModelTier.SELF_AWARE) continue;
            mc.field_71466_p.func_238405_a_(e.getMatrixStack(), I18n.func_135052_a((String)"hostilenetworks.hud.kills", (Object[])new Object[]{cModel.getKillsNeeded()}), (float)(x + 21), (float)(y + 12 + i * spacing), 0xFFFFFF);
        }
    }

    public static void drawModel(Minecraft mc, int x, int y, ItemStack stack, CachedModel model) {
        mc.func_175599_af().func_180450_b(stack, x, y + 9);
        ITextComponent comp = model.getTier().getComponent();
        MatrixStack matrix = new MatrixStack();
        mc.field_71466_p.func_243246_a(matrix, comp, (float)(x + 4), (float)y, 0xFFFFFF);
        mc.field_71466_p.func_243246_a(matrix, (ITextComponent)new TranslationTextComponent("hostilenetworks.hud.model"), (float)(x + mc.field_71466_p.func_238414_a_((ITextProperties)comp) + 4), (float)y, 0xFFFFFF);
        mc.func_110434_K().func_110577_a(DL_HUD);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 18), (int)(y + 10), (float)0.0f, (float)0.0f, (int)89, (int)12, (int)256, (int)256);
        int width = 87;
        if (model.getTier() != ModelTier.SELF_AWARE) {
            width = MathHelper.func_76123_f((float)((float)(width * model.getData()) / (float)model.getTier().next().data));
        }
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 19), (int)(y + 11), (float)0.0f, (float)12.0f, (int)width, (int)10, (int)256, (int)256);
    }
}

