/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.data.DataModelManager;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.DataModelItem;
import shadows.hostilenetworks.item.DeepLearnerItem;

@Mod.EventBusSubscriber(modid="hostilenetworks")
public class HostileEvents {
    @SubscribeEvent
    public static void modelAttunement(PlayerInteractEvent.EntityInteractSpecific e) {
        PlayerEntity player = e.getPlayer();
        ItemStack stack = player.func_184586_b(e.getHand());
        if (stack.func_77973_b() == Hostile.Items.BLANK_DATA_MODEL) {
            if (!player.field_70170_p.field_72995_K) {
                DataModel model = DataModelManager.INSTANCE.getModel(e.getTarget().func_200600_R());
                if (model == null) {
                    IFormattableTextComponent msg = new TranslationTextComponent("hostilenetworks.msg.no_model").func_240699_a_(TextFormatting.RED);
                    player.func_145747_a((ITextComponent)msg, Util.field_240973_b_);
                    return;
                }
                IFormattableTextComponent msg = new TranslationTextComponent("hostilenetworks.msg.built", new Object[]{model.getName()}).func_240699_a_(TextFormatting.GOLD);
                player.func_145747_a((ITextComponent)msg, Util.field_240973_b_);
                ItemStack modelStack = new ItemStack((IItemProvider)Hostile.Items.DATA_MODEL);
                DataModelItem.setStoredModel(modelStack, model);
                player.func_184611_a(e.getHand(), modelStack);
            }
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void reloads(AddReloadListenerEvent e) {
        e.addListener((IFutureReloadListener)DataModelManager.INSTANCE);
    }

    @SubscribeEvent
    public static void kill(LivingDeathEvent e) {
        Entity src = e.getSource().func_76346_g();
        if (src instanceof ServerPlayerEntity) {
            ServerPlayerEntity p = (ServerPlayerEntity)src;
            p.field_71071_by.field_70462_a.stream().filter(s -> s.func_77973_b() == Hostile.Items.DEEP_LEARNER).forEach(dl -> HostileEvents.updateModels(dl, e.getEntityLiving().func_200600_R(), 0));
            if (p.func_184592_cb().func_77973_b() == Hostile.Items.DEEP_LEARNER) {
                HostileEvents.updateModels(p.func_184592_cb(), e.getEntityLiving().func_200600_R(), 0);
            }
        }
    }

    public static void updateModels(ItemStack learner, EntityType<?> type, int bonus) {
        ItemStackHandler handler = DeepLearnerItem.getItemHandler(learner);
        for (int i = 0; i < 4; ++i) {
            DataModel dModel;
            ItemStack model = handler.getStackInSlot(i);
            if (model.func_190926_b() || (dModel = DataModelItem.getStoredModel(model)).getType() != type) continue;
            int data = DataModelItem.getData(model);
            ModelTier tier = ModelTier.getByData(data);
            DataModelItem.setData(model, data + tier.dataPerKill + bonus);
        }
        DeepLearnerItem.saveItems(learner, handler);
    }

    @SubscribeEvent
    public static void sync(OnDatapackSyncEvent e) {
        ServerPlayerEntity p = e.getPlayer();
        if (p == null) {
            for (PlayerEntity pe : e.getPlayerList().func_181057_v()) {
                DataModelManager.dispatch(pe);
            }
        } else if (!p.field_70170_p.field_72995_K) {
            DataModelManager.dispatch((PlayerEntity)p);
        }
    }
}

