/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.IWidget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class WLine
implements IWidget {
    int xPos;
    int yPos;
    int xSize;
    int ySize;

    public WLine(int y) {
        this(7, y, 162, true);
    }

    public WLine(int xPos, int yPos, int size, boolean horizontal) {
        this.yPos = yPos;
        this.xPos = xPos;
        if (horizontal) {
            this.xSize = size;
            this.ySize = 2;
        } else {
            this.xSize = 2;
            this.ySize = size;
        }
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        gui.drawResourceContinuous(Resource.WGT_SLOT, this.xPos, this.yPos, this.xSize, this.ySize, 1);
        return false;
    }

    public static class Joint
    implements IWidget {
        int xPos;
        int yPos;
        boolean up;
        boolean down;
        boolean left;
        boolean right;
        public static Resource u = Resource.WGT_SLOT.sub(9, 0, 2, 1);
        public static Resource d = Resource.WGT_SLOT.sub(9, 19, 2, 1);
        public static Resource l = Resource.WGT_SLOT.sub(0, 9, 1, 2);
        public static Resource r = Resource.WGT_SLOT.sub(19, 9, 1, 2);
        public static Resource ul = Resource.WGT_SLOT.sub(0, 0, 1, 1);
        public static Resource ur = Resource.WGT_SLOT.sub(19, 0, 1, 1);
        public static Resource ll = Resource.WGT_SLOT.sub(0, 19, 1, 1);
        public static Resource lr = Resource.WGT_SLOT.sub(19, 19, 1, 1);

        public Joint(int xPos, int yPos, boolean up, boolean down, boolean left, boolean right) {
            this.xPos = xPos;
            this.yPos = yPos;
            this.up = up;
            this.down = down;
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
            if (!this.up) {
                gui.drawResource(u, this.xPos, this.yPos);
            }
            if (!this.down) {
                gui.drawResource(d, this.xPos, this.yPos + 1);
            }
            if (!this.left) {
                gui.drawResource(l, this.xPos, this.yPos);
            }
            if (!this.right) {
                gui.drawResource(r, this.xPos + 1, this.yPos);
            }
            if (this.left == this.up) {
                gui.drawResource(ul, this.xPos, this.yPos);
            }
            if (this.right == this.up) {
                gui.drawResource(ur, this.xPos + 1, this.yPos);
            }
            if (this.left == this.down) {
                gui.drawResource(ll, this.xPos, 1 + this.yPos);
            }
            if (this.right == this.down) {
                gui.drawResource(lr, this.xPos + 1, this.yPos + 1);
            }
            return false;
        }
    }
}

