/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.widgets;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.widgets.WButton;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class WButtonIcon
extends WButton {
    protected Resource rNormal;
    protected Resource rDisabled;

    public WButtonIcon(int xPos, int yPos, int xSize, int ySize, Resource.ResourceGroup res, String name) {
        this(xPos, yPos, xSize, ySize, res.one, res.two, name);
    }

    public WButtonIcon(int xPos, int yPos, int xSize, int ySize, Resource.ResourceGroup res) {
        this(xPos, yPos, xSize, ySize, res.one, res.two, null);
    }

    private WButtonIcon(int xPos, int yPos, int xSize, int ySize, Resource normal, @Nullable Resource disabled, @Nullable String name) {
        super(xPos, yPos, xSize, ySize, name);
        this.rNormal = normal;
        this.rDisabled = disabled;
    }

    @Override
    public boolean onDraw(JecaGui gui, int xMouse, int yMouse) {
        Resource r;
        boolean ret = super.onDraw(gui, xMouse, yMouse);
        Resource resource = r = this.disabled ? this.rDisabled : this.rNormal;
        if (r != null) {
            int x = this.xPos + (this.xSize - r.getXSize() + 1) / 2;
            int y = this.yPos + (this.ySize - r.getYSize() + 1) / 2;
            gui.drawResource(r, x, y);
        }
        return ret;
    }
}

