/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis.pickers;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.label.labels.LFluidStack;
import me.towdium.jecalculation.data.label.labels.LFluidTag;
import me.towdium.jecalculation.data.label.labels.LItemTag;
import me.towdium.jecalculation.data.label.labels.LTag;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.guis.pickers.IPicker;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabelScroll;
import me.towdium.jecalculation.gui.widgets.WSearch;
import net.minecraft.fluid.Fluid;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class PickerSimple
extends IPicker.Impl
implements IGui {
    public PickerSimple(List<ILabel> labels) {
        WLabelScroll ls = new WLabelScroll(7, 33, 8, 7, false).setLabels(labels).setLsnrClick((i, v) -> this.notifyLsnr(i.get((int)v).getLabel()));
        this.add(new WIcon(7, 7, 20, 20, Resource.ICN_TEXT, "common.search"));
        this.add(new WSearch(26, 7, 90, ls));
        this.add(ls);
    }

    public static class Tag
    extends PickerSimple {
        public Tag() {
            super(Tag.generate());
        }

        static List<ILabel> generate() {
            Stream<LItemTag> items = ItemTags.func_199903_a().func_241833_a().entrySet().stream().filter(i -> !((ITag)i.getValue()).func_230236_b_().isEmpty()).map(i -> new LItemTag((ResourceLocation)i.getKey())).sorted(Comparator.comparing(LTag::getName));
            Stream<LFluidTag> fluids = FluidTags.func_226157_a_().func_241833_a().entrySet().stream().filter(i -> !((ITag)i.getValue()).func_230236_b_().isEmpty()).map(i -> new LFluidTag((ResourceLocation)i.getKey())).sorted(Comparator.comparing(LTag::getName));
            return Stream.of(items, fluids).flatMap(i -> i).collect(Collectors.toList());
        }
    }

    public static class FluidStack
    extends PickerSimple {
        public FluidStack() {
            super(ForgeRegistries.FLUIDS.getValues().stream().filter(i -> i.func_207193_c(i.func_207188_f())).map(i -> new LFluidStack(1000L, (Fluid)i)).collect(Collectors.toList()));
        }
    }
}

