/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiCraft;
import me.towdium.jecalculation.gui.guis.GuiMath;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.jei.JecaPlugin;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Wrapper;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.common.Mod;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(value={Dist.CLIENT})
@OnlyIn(value=Dist.CLIENT)
public class JecaGui
extends ContainerScreen<JecaContainer> {
    public static final KeyBinding keyOpenGuiCraft = new KeyBinding("jecalculation.key.gui_craft", -1, "jecalculation.key.category");
    public static final KeyBinding keyOpenGuiMath = new KeyBinding("jecalculation.key.gui_math", -1, "jecalculation.key.category");
    public static final int COLOR_GUI_GREY = -6184543;
    public static final int COLOR_TEXT_RED = 0xFF0000;
    public static final int COLOR_TEXT_GREY = 0x404040;
    public static final int COLOR_TEXT_WHITE = 0xFFFFFF;
    public static final boolean ALWAYS_TOOLTIP = false;
    public static final String SEPARATOR = new String();
    public ILabel hand = ILabel.EMPTY;
    protected static JecaGui last;
    protected static JecaGui override;
    protected JecaGui parent;
    protected MatrixStack matrix;
    public IGui root;

    public JecaGui(@Nullable JecaGui parent, IGui root) {
        this(parent, false, root);
    }

    public JecaGui(@Nullable JecaGui parent, boolean acceptsTransfer, IGui root) {
        super((Container)(acceptsTransfer ? new ContainerTransfer() : new ContainerNonTransfer()), Utilities.getPlayer().field_71071_by, (ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        this.root = root;
        if (this.field_147002_h != null) {
            ((JecaContainer)this.field_147002_h).setGui(this);
        }
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        minecraft.field_195559_v.func_197967_a(true);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        Objects.requireNonNull(this.field_230706_i_);
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public static int getMouseX() {
        JecaGui gui = JecaGui.getCurrent();
        Minecraft mc = Objects.requireNonNull(gui.field_230706_i_, "Internal error");
        int windowWidth = mc.func_228018_at_().func_198105_m();
        if (windowWidth == 0) {
            return 0;
        }
        return (int)mc.field_71417_B.func_198024_e() * mc.func_228018_at_().func_198107_o() / windowWidth - gui.field_147003_i;
    }

    public static int getMouseY() {
        JecaGui gui = JecaGui.getCurrent();
        Minecraft mc = Objects.requireNonNull(gui.field_230706_i_, "Internal error");
        int windowHeight = mc.func_228018_at_().func_198083_n();
        if (windowHeight == 0) {
            return 0;
        }
        return (int)mc.field_71417_B.func_198026_f() * mc.func_228018_at_().func_198087_p() / windowHeight - gui.field_147009_r;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onFocus(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (!(event.getGui() instanceof JecaGui)) {
            return;
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        int button = event.getButton();
        gui.root.onMouseFocused(gui, xMouse, yMouse, button);
        ILabel e = JecaPlugin.getLabelUnderMouse();
        if (e != ILabel.EMPTY) {
            gui.hand = e;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onMouse(GuiScreenEvent.MouseInputEvent event) {
        if (!(event.getGui() instanceof JecaGui)) {
            return;
        }
        JecaGui gui = JecaGui.getCurrent();
        int xMouse = JecaGui.getMouseX();
        int yMouse = JecaGui.getMouseY();
        if (event instanceof GuiScreenEvent.MouseScrollEvent.Pre) {
            double diff = ((GuiScreenEvent.MouseScrollEvent)event).getScrollDelta();
            if (diff != 0.0) {
                gui.root.onMouseScroll(gui, xMouse, yMouse, (int)diff);
            }
        } else if (event instanceof GuiScreenEvent.MouseClickedEvent.Pre) {
            int button = ((GuiScreenEvent.MouseClickedEvent)event).getButton();
            if (gui.root.onMouseClicked(gui, xMouse, yMouse, button)) {
                event.setCanceled(true);
            } else if (gui.hand != ILabel.EMPTY) {
                gui.hand = ILabel.EMPTY;
                event.setCanceled(true);
            }
        } else if (event instanceof GuiScreenEvent.MouseDragEvent.Pre) {
            GuiScreenEvent.MouseDragEvent mde = (GuiScreenEvent.MouseDragEvent)event;
            gui.root.onMouseDragged(gui, xMouse, yMouse, (int)mde.getDragX(), (int)mde.getDragY());
        } else if (event instanceof GuiScreenEvent.MouseReleasedEvent.Pre) {
            int button = ((GuiScreenEvent.MouseReleasedEvent)event).getButton();
            gui.root.onMouseReleased(gui, xMouse, yMouse, button);
        }
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.root.onTick(this);
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Object rep;
        Inventory i = new Inventory(new ItemStack[]{ItemStack.field_190927_a});
        Slot s = new Slot((IInventory)i, 0, 0, 0);
        ILabel l = this.getLabelUnderMouse();
        Object object = rep = l == null ? null : l.getRepresentation();
        if (rep instanceof ItemStack) {
            s.func_75215_d((ItemStack)rep);
        }
        return s;
    }

    public static boolean mouseIn(int xPos, int yPos, int xSize, int ySize, int xMouse, int yMouse) {
        return xMouse > xPos && yMouse > yPos && xMouse <= xPos + xSize && yMouse <= yPos + ySize;
    }

    public static void displayGui(IGui root) {
        Screen s = Minecraft.func_71410_x().field_71462_r;
        if (s instanceof JecaGui) {
            JecaGui.displayGui(root, true);
        } else {
            JecaGui.displayGui(root, null);
        }
    }

    public static void displayGui(IGui root, @Nullable JecaGui parent) {
        Minecraft mc = Minecraft.func_71410_x();
        Screen s = mc.field_71462_r;
        JecaGui gui = new JecaGui(parent, root.acceptsTransfer(), root);
        if (s instanceof IRecipesGui || s instanceof ChatScreen) {
            override = gui;
        } else {
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.CLIENT);
            executor.func_213165_a(() -> {
                root.onVisible(gui);
                last = gui;
                mc.func_147108_a((Screen)gui);
            });
        }
    }

    public static void displayGui(IGui root, boolean updateParent) {
        JecaGui current = JecaGui.getCurrent();
        JecaGui parent = updateParent ? current : current.parent;
        JecaGui.displayGui(root, parent);
    }

    public MatrixStack getMatrix() {
        return this.matrix;
    }

    public static JecaGui getCurrent() {
        Screen gui = Minecraft.func_71410_x().field_71462_r;
        JecaGui ret = gui instanceof JecaGui ? (JecaGui)gui : null;
        Objects.requireNonNull(ret);
        return ret;
    }

    public static JecaGui getLast() {
        return last;
    }

    public static void displayParent() {
        JecaGui gui = JecaGui.getCurrent().parent;
        gui.root.onVisible(gui);
        last = gui;
        Minecraft.func_71410_x().func_147108_a((Screen)gui);
    }

    @Nullable
    public ILabel getLabelUnderMouse() {
        Wrapper<Object> l = new Wrapper<Object>(null);
        this.root.getLabelUnderMouse(JecaGui.getMouseX(), JecaGui.getMouseY(), l);
        return (ILabel)l.value;
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent event) {
        if (keyOpenGuiCraft.func_151470_d()) {
            JecaGui.openGuiCraft(null);
        }
        if (keyOpenGuiMath.func_151470_d()) {
            JecaGui.openGuiMath(null);
        }
    }

    @SubscribeEvent
    public static void onTooltip(RenderTooltipEvent.Pre event) {
        JecaGui gui;
        boolean overlap;
        if (Minecraft.func_71410_x().field_71462_r instanceof JecaGui && (overlap = gui.root.onTooltip(gui = JecaGui.getCurrent(), event.getX() - gui.field_147003_i, event.getY() - gui.field_147009_r, new ArrayList<String>())) && !event.getStack().func_190926_b()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiOpen(GuiOpenEvent e) {
        if (override != null) {
            JecaGui.override.root.onVisible(override);
            last = override;
            e.setGui((Screen)override);
            override = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int openGuiMath(@Nullable ItemStack is) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent(s), false);
        } else {
            JecaGui.displayGui(new GuiMath(is));
        }
        return ret ? 1 : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int openGuiCraft(@Nullable ItemStack is) {
        boolean ret = is == null && Controller.isServerActive();
        String s = "jecalculation.chat.server_mode";
        if (ret) {
            Utilities.getPlayer().func_146105_b((ITextComponent)new TranslationTextComponent(s), false);
        } else {
            JecaGui.displayGui(new GuiCraft(is));
        }
        return ret ? 1 : 0;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.matrix = matrixStack;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        this.root.onDraw(this, mouseX -= this.field_147003_i, mouseY -= this.field_147009_r);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)80.0f);
        this.hand.drawLabel(this, mouseX + this.field_147003_i, mouseY + this.field_147009_r, true);
        RenderSystem.popMatrix();
        ArrayList<String> tooltip = new ArrayList<String>();
        this.root.onTooltip(this, mouseX, mouseY, tooltip);
        this.drawHoveringText(matrixStack, tooltip, mouseX + this.field_147003_i, mouseY + this.field_147009_r, this.field_230712_o_);
    }

    public void drawHoveringText(MatrixStack matrixStack, List<String> textLines, int x, int y, FontRenderer font) {
        if (!textLines.isEmpty()) {
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableDepthTest();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)400.0f);
            int i = 0;
            int separators = 0;
            for (String s : textLines) {
                int j = this.field_230712_o_.func_78256_a(s);
                if (j > i) {
                    i = j;
                }
                if (s != SEPARATOR) continue;
                ++separators;
            }
            if (textLines.get(textLines.size() - 1) == SEPARATOR) {
                --separators;
            }
            int l1 = x + 12;
            int i2 = y - 12;
            int k = 8 + (textLines.size() - separators - 1) * 10 + 2 * separators;
            if (l1 + i > this.field_230708_k_) {
                l1 -= 28 + i;
            }
            if (i2 + k + 6 > this.field_230709_l_) {
                i2 = this.field_230709_l_ - k - 6;
            }
            this.func_238468_a_(matrixStack, l1 - 3, i2 - 4, l1 + i + 3, i2 - 3, -267386864, -267386864);
            this.func_238468_a_(matrixStack, l1 - 3, i2 + k + 3, l1 + i + 3, i2 + k + 4, -267386864, -267386864);
            this.func_238468_a_(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 + k + 3, -267386864, -267386864);
            this.func_238468_a_(matrixStack, l1 - 4, i2 - 3, l1 - 3, i2 + k + 3, -267386864, -267386864);
            this.func_238468_a_(matrixStack, l1 + i + 3, i2 - 3, l1 + i + 4, i2 + k + 3, -267386864, -267386864);
            this.func_238468_a_(matrixStack, l1 - 3, i2 - 3 + 1, l1 - 3 + 1, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_238468_a_(matrixStack, l1 + i + 2, i2 - 3 + 1, l1 + i + 3, i2 + k + 3 - 1, 0x505000FF, 1344798847);
            this.func_238468_a_(matrixStack, l1 - 3, i2 - 3, l1 + i + 3, i2 - 3 + 1, 0x505000FF, 0x505000FF);
            this.func_238468_a_(matrixStack, l1 - 3, i2 + k + 2, l1 + i + 3, i2 + k + 3, 1344798847, 1344798847);
            for (String s1 : textLines) {
                if (s1 == SEPARATOR) {
                    i2 += 2;
                    continue;
                }
                font.func_238405_a_(matrixStack, s1, (float)l1, (float)i2, -1);
                i2 += 10;
            }
            RenderSystem.popMatrix();
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
        }
    }

    public void drawResource(Resource r, int xPos, int yPos) {
        this.drawResource(r, xPos, yPos, 0xFFFFFF);
    }

    public void drawResource(Resource r, int xPos, int yPos, int color) {
        this.setColor(color);
        Objects.requireNonNull(this.field_230706_i_).func_110434_K().func_110577_a(r.getResourceLocation());
        this.func_238474_b_(this.matrix, xPos, yPos, r.getXPos(), r.getYPos(), r.getXSize(), r.getYSize());
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int border) {
        this.drawResourceContinuous(r, xPos, yPos, xSize, ySize, border, border, border, border);
    }

    public void drawResourceContinuous(Resource r, int xPos, int yPos, int xSize, int ySize, int borderTop, int borderBottom, int borderLeft, int borderRight) {
        GuiUtils.drawContinuousTexturedBox((MatrixStack)this.matrix, (ResourceLocation)r.getResourceLocation(), (int)xPos, (int)yPos, (int)r.getXPos(), (int)r.getYPos(), (int)xSize, (int)ySize, (int)r.getXSize(), (int)r.getYSize(), (int)borderTop, (int)borderBottom, (int)borderLeft, (int)borderRight, (float)0.0f);
    }

    private void setColor(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(~(color >> 24) & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void drawFluid(Fluid f, int xPos, int yPos, int xSize, int ySize) {
        TextureAtlasSprite fluidTexture = Objects.requireNonNull(this.field_230706_i_).func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(f.getFluid().getAttributes().getStillTexture());
        this.field_230706_i_.field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        this.setColor(f.getAttributes().getColor() & 0xFFFFFF);
        JecaGui.func_238470_a_((MatrixStack)this.matrix, (int)xPos, (int)yPos, (int)0, (int)xSize, (int)ySize, (TextureAtlasSprite)fluidTexture);
    }

    public void drawRectangle(int xPos, int yPos, int xSize, int ySize, int color) {
        JecaGui.func_238467_a_((MatrixStack)this.matrix, (int)xPos, (int)yPos, (int)(xPos + xSize), (int)(yPos + ySize), (int)color);
    }

    public int getStringWidth(String s) {
        return this.field_230712_o_.func_78256_a(s);
    }

    public void drawSplitText(float xPos, float yPos, int width, Font f, String s) {
        this.drawSplitText(xPos, yPos, f, Utilities.I18n.wrap(s, width));
    }

    public void drawSplitText(float xPos, float yPos, Font f, List<String> ss) {
        this.drawText(xPos, yPos, f, () -> {
            int y = 0;
            for (String i : ss) {
                if (f.shadow) {
                    this.field_230712_o_.func_238405_a_(this.matrix, i, 0.0f, (float)y, f.color);
                } else {
                    this.field_230712_o_.func_238421_b_(this.matrix, i, 0.0f, (float)y, f.color);
                }
                this.field_230712_o_.getClass();
                y += 9 + 1;
            }
        });
    }

    public void drawText(float xPos, float yPos, Font f, String s) {
        this.drawText(xPos, yPos, Integer.MAX_VALUE, f, s);
    }

    public void drawText(float xPos, float yPos, int width, Font f, String s) {
        this.drawText(xPos, yPos, f, () -> {
            String str = s;
            int strWidth = f.getTextWidth(str);
            int ellipsisWidth = f.getTextWidth("...");
            if (strWidth > width && strWidth > ellipsisWidth) {
                str = f.trimToWidth(str, width - ellipsisWidth).trim() + "...";
            }
            if (f.shadow) {
                this.field_230712_o_.func_238405_a_(this.matrix, str, 0.0f, 0.0f, f.color);
            } else {
                this.field_230712_o_.func_238421_b_(this.matrix, str, 0.0f, 0.0f, f.color);
            }
        });
    }

    private void drawText(float xPos, float yPos, Font f, Runnable r) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)xPos, (float)yPos, (float)200.0f);
        if (f.half) {
            RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        }
        r.run();
        RenderSystem.popMatrix();
    }

    public void drawItemStack(int xPos, int yPos, ItemStack is, boolean centred) {
        if (centred) {
            xPos -= 8;
            yPos -= 8;
        }
        RenderSystem.enableDepthTest();
        FontRenderer font = is.func_77973_b().getFontRenderer(is);
        if (font == null) {
            font = this.field_230712_o_;
        }
        this.field_230707_j_.func_180450_b(is, xPos, yPos);
        this.field_230707_j_.func_180453_a(font, is, xPos, yPos, null);
        this.field_230707_j_.func_175042_a(is, xPos, yPos);
        RenderHelper.func_74518_a();
        RenderSystem.disableDepthTest();
    }

    protected void func_231160_c_() {
        this.field_147003_i = (this.field_230708_k_ - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_230709_l_ - this.field_147000_g) / 2;
    }

    public boolean func_231042_a_(char ch, int modifier) {
        return this.root.onChar(this, ch, modifier) || super.func_231042_a_(ch, modifier);
    }

    public boolean func_231046_a_(int key, int scan, int modifier) {
        if (key == 256 && this.hand != ILabel.EMPTY) {
            this.hand = ILabel.EMPTY;
        } else if (!this.root.onKeyPressed(this, key, modifier)) {
            if (key == 256 && this.parent != null) {
                JecaGui.displayParent();
            } else {
                return super.func_231046_a_(key, scan, modifier);
            }
        }
        return true;
    }

    public boolean func_223281_a_(int key, int scan, int modifier) {
        return this.root.onKeyReleased(this, key, modifier) || super.func_223281_a_(key, scan, modifier);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContainerNonTransfer
    extends JecaContainer {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ContainerTransfer
    extends JecaContainer {
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    @OnlyIn(value=Dist.CLIENT)
    public static class JecaContainer
    extends Container {
        JecaGui gui;

        protected JecaContainer() {
            super(null, 0);
        }

        public JecaGui getGui() {
            return this.gui;
        }

        public void setGui(JecaGui gui) {
            this.gui = gui;
        }

        public boolean func_75145_c(PlayerEntity playerIn) {
            return true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Font {
        public static final Font SHADOW = new Font(0xFFFFFF, true, false, false);
        public static final Font PLAIN = new Font(0x404040, false, false, false);
        public static final Font RAW = new Font(0x404040, false, false, true);
        public static final Font HALF = new Font(0xFFFFFF, true, true, true);
        public int color;
        public boolean shadow;
        public boolean half;
        public boolean raw;

        public Font(int color, boolean shadow, boolean half, boolean raw) {
            this.color = color;
            this.shadow = shadow;
            this.half = half;
            this.raw = raw;
        }

        public int getTextWidth(String s) {
            return (int)Math.ceil((float)JecaGui.getCurrent().field_230712_o_.func_78256_a(s) * (this.half ? 0.5f : 1.0f));
        }

        public int getTextHeight() {
            JecaGui.getCurrent().field_230712_o_.getClass();
            return (int)Math.ceil(9.0f * (this.half ? 0.5f : 1.0f));
        }

        public String trimToWidth(String s, int i) {
            return JecaGui.getCurrent().field_230712_o_.func_238412_a_(s, i * (this.half ? 2 : 1));
        }
    }
}

