/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.net;

import java.util.function.Supplier;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageBalance {
    private final int id;
    private final boolean spread;

    public MessageBalance(int id, boolean spread) {
        this.id = id;
        this.spread = spread;
    }

    public static MessageBalance decode(PacketBuffer buf) {
        byte id = buf.readByte();
        boolean spread = buf.readBoolean();
        return new MessageBalance(id, spread);
    }

    public static void encode(MessageBalance message, PacketBuffer buf) {
        buf.writeByte(message.id);
        buf.writeBoolean(message.spread);
    }

    public static void handle(MessageBalance message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            TweakProvider<Container> tweakProvider;
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container != null && (tweakProvider = CraftingTweaksProviderManager.getProvider(container)) != null) {
                if (message.spread) {
                    tweakProvider.spreadGrid((PlayerEntity)player, container, message.id);
                } else {
                    tweakProvider.balanceGrid((PlayerEntity)player, container, message.id);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

