/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.CraftingTweaksProviderManager;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.client.ClientProvider;
import net.blay09.mods.craftingtweaks.client.CraftingTweaksClient;
import net.blay09.mods.craftingtweaks.client.GuiImageButton;
import net.blay09.mods.craftingtweaks.client.ITooltipProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiTweakButton
extends GuiImageButton
implements ITooltipProvider {
    private final TweakOption tweakOption;
    private final int tweakId;
    private final ContainerScreen<?> parentGui;
    private int lastGuiLeft;
    private int lastGuiTop;

    public GuiTweakButton(@Nullable ContainerScreen<?> parentGui, int xPosition, int yPosition, int texCoordX, int texCoordY, TweakOption tweakOption, int tweakId) {
        super(xPosition, yPosition, texCoordX, texCoordY);
        this.parentGui = parentGui;
        if (parentGui != null) {
            this.lastGuiLeft = parentGui.getGuiLeft();
            this.lastGuiTop = parentGui.getGuiTop();
        }
        this.tweakOption = tweakOption;
        this.tweakId = tweakId;
    }

    public TweakOption getTweakOption() {
        return this.tweakOption;
    }

    public int getTweakId() {
        return this.tweakId;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Container container = player.field_71070_bA;
        TweakProvider<Container> provider = CraftingTweaksProviderManager.getProvider(container);
        if (provider != null) {
            ClientProvider clientProvider = CraftingTweaks.craftingTweaksClient.map(CraftingTweaksClient::getClientProvider).orElseThrow(() -> new IllegalStateException("Missing CraftingTweaks ClientProvider."));
            this.onTweakButtonClicked((PlayerEntity)player, container, provider, clientProvider);
        }
    }

    protected abstract void onTweakButtonClicked(PlayerEntity var1, Container var2, TweakProvider<Container> var3, ClientProvider var4);

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.parentGui != null) {
            int guiLeft = this.parentGui.getGuiLeft();
            int guiTop = this.parentGui.getGuiTop();
            if (guiLeft != this.lastGuiLeft || guiTop != this.lastGuiTop) {
                this.field_230690_l_ += guiLeft - this.lastGuiLeft;
                this.field_230691_m_ += guiTop - this.lastGuiTop;
            }
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }
        int oldTexCoordX = this.texCoordX;
        if (Screen.func_231173_s_()) {
            this.texCoordX += 48;
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.texCoordX = oldTexCoordX;
    }

    @Override
    public List<ITextComponent> getTooltip() {
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        switch (this.tweakOption) {
            case Rotate: {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.craftingtweaks.rotate"));
                break;
            }
            case Clear: {
                if (Screen.func_231173_s_()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.craftingtweaks.forceClear"));
                    TranslationTextComponent forceClearInfoText = new TranslationTextComponent("tooltip.craftingtweaks.forceClear");
                    forceClearInfoText.func_240699_a_(TextFormatting.GRAY);
                    tooltip.add((ITextComponent)forceClearInfoText);
                    break;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.craftingtweaks.clear"));
                break;
            }
            case Balance: {
                if (Screen.func_231173_s_()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.craftingtweaks.spread"));
                    break;
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.craftingtweaks.balance"));
            }
        }
        return tooltip;
    }

    public static enum TweakOption {
        Rotate,
        Balance,
        Clear;

    }
}

