/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.slurry;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.helper.ChannelModule;
import terrails.xnetgases.module.slurry.SlurryChannelSettings;
import terrails.xnetgases.module.slurry.SlurryConnectorSettings;
import terrails.xnetgases.module.slurry.SlurryUtils;

public class SlurryChannelModule
extends ChannelModule {
    public static ForgeConfigSpec.IntValue maxSlurryRateNormal;
    public static ForgeConfigSpec.IntValue maxSlurryRateAdvanced;

    public String getID() {
        return "mekanism.slurry";
    }

    public String getName() {
        return "Mekanism Slurry";
    }

    public boolean supportsBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)world.func_175625_s(pos), direction).isPresent();
    }

    @Nonnull
    public IConnectorSettings createConnector(@Nonnull Direction direction) {
        return new SlurryConnectorSettings(direction);
    }

    @Nonnull
    public IChannelSettings createChannel() {
        return new SlurryChannelSettings();
    }

    @Override
    public void setupConfig(ForgeConfigSpec.Builder builder) {
        maxSlurryRateNormal = builder.comment("Maximum slurry per operation that a normal connector can input or output").defineInRange("maxSlurryRateNormal", 1000, 1, 1000000000);
        maxSlurryRateAdvanced = builder.comment("Maximum slurry per operation that an advanced connector can input or output").defineInRange("maxSlurryRateAdvanced", 5000, 1, 1000000000);
    }
}

