/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.item.ItemExperienceBook;
import wayoftime.bloodmagic.common.item.ItemLivingArmor;
import wayoftime.bloodmagic.core.AnointmentRegistrar;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.network.DemonAuraClientPacket;
import wayoftime.bloodmagic.potion.BMPotionUtils;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.InventoryHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GenericHandler {
    public static Map<UUID, Double> posXMap = new HashMap<UUID, Double>();
    public static Map<UUID, Double> posZMap = new HashMap<UUID, Double>();
    public static Map<UUID, Integer> foodMap = new HashMap<UUID, Integer>();
    private static final Map<ItemStack, Double> rollMap = new HashMap<ItemStack, Double>();
    public static Map<UUID, Integer> curiosLevelMap = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBindable) {
            IBindable bindable = (IBindable)held.func_77973_b();
            Binding binding = bindable.getBinding(held);
            if (binding == null) {
                if (bindable.onBind(player, held)) {
                    ItemBindEvent toPost = new ItemBindEvent(player, held);
                    if (MinecraftForge.EVENT_BUS.post((Event)toPost)) {
                        return;
                    }
                    BindableHelper.applyBinding(held, player);
                }
            } else if (binding.getOwnerId().equals(player.func_146103_bH().getId()) && !binding.getOwnerName().equals(player.func_146103_bH().getName())) {
                binding.setOwnerName(player.func_146103_bH().getName());
                BindableHelper.applyBinding(held, binding);
            }
        }
        if (!held.func_190926_b() && held.func_77973_b() instanceof IBloodOrb) {
            IBloodOrb bloodOrb = (IBloodOrb)held.func_77973_b();
            SoulNetwork network = NetworkHelper.getSoulNetwork(player);
            BloodOrb orb = bloodOrb.getOrb(held);
            if (orb == null) {
                return;
            }
            if (orb.getTier() > network.getOrbTier()) {
                network.setOrbTier(orb.getTier());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        PlayerEntity player;
        Entity sourceEntity = event.getSource().func_76346_g();
        LivingEntity living = event.getEntityLiving();
        if (sourceEntity instanceof PlayerEntity) {
            ItemStack heldStack;
            AnointmentHolder holder;
            PlayerEntity sourcePlayer = (PlayerEntity)sourceEntity;
            if (LivingUtil.hasFullSet(sourcePlayer)) {
                ItemStack mainWeapon = sourcePlayer.func_184607_cu();
                double additionalDamage = LivingUtil.getAdditionalDamage(sourcePlayer, mainWeapon, living, event.getAmount());
                event.setAmount((float)((double)event.getAmount() + additionalDamage));
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = sourcePlayer.func_184614_ca())) != null) {
                double additionalDamage = holder.getAdditionalDamage(sourcePlayer, heldStack, event.getAmount(), living);
                event.setAmount((float)((double)event.getAmount() + additionalDamage));
            }
        }
        if (living instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)living)) {
            event.setAmount((float)LivingUtil.getDamageReceivedForArmour(player, event.getSource(), event.getAmount()));
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        PlayerEntity player;
        Entity sourceEntity = event.getSource().func_76346_g();
        LivingEntity living = event.getEntityLiving();
        if (sourceEntity instanceof PlayerEntity) {
            ItemStack heldStack;
            AnointmentHolder holder;
            PlayerEntity sourcePlayer = (PlayerEntity)sourceEntity;
            if (LivingUtil.hasFullSet(sourcePlayer) && sourcePlayer.func_70051_ag()) {
                LivingUtil.applyNewExperience(sourcePlayer, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPRINT_ATTACK.get()), event.getAmount());
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = sourcePlayer.func_184614_ca())) != null && holder.consumeAnointmentDurabilityOnHit(heldStack, EquipmentSlotType.MAINHAND, (LivingEntity)sourcePlayer)) {
                holder.toItemStack(heldStack);
            }
        }
        if (living instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)living)) {
            if (event.getSource().func_76352_a()) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_ARROW_PROTECT.get()), event.getAmount());
            } else {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_PHYSICAL_PROTECT.get()), event.getAmount());
            }
            if (event.getSource() == DamageSource.field_76379_h) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FALL_PROTECT.get()), event.getAmount());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExperiencePickupHighest(PlayerXpEvent.PickupXp event) {
        PlayerEntity player;
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)living)) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            double expModifier = 1.0 + ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get())).getBonusValue("exp", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get())).getKey())).doubleValue();
            int xp = event.getOrb().field_70530_e;
            event.getOrb().field_70530_e = (int)Math.floor((double)xp * expModifier) + (player.field_70170_p.field_73012_v.nextDouble() < (double)xp * expModifier % 1.0 ? 1 : 0);
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get()), event.getOrb().func_70526_d());
        }
    }

    @SubscribeEvent
    public void onHoe(BlockEvent.BlockToolInteractEvent event) {
        if (event.getToolType() == ToolType.HOE && Tags.Blocks.NETHERRACK.func_230235_a_((Object)event.getState().func_177230_c())) {
            event.setFinalState(((Block)BloodMagicBlocks.NETHER_SOIL.get()).func_176223_P());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperiencePickup(PlayerXpEvent.PickupXp event) {
        ItemStack itemStack;
        PlayerEntity player = event.getPlayer();
        Map.Entry entry = EnchantmentHelper.func_222189_b((Enchantment)Enchantments.field_185296_A, (LivingEntity)player);
        if (entry != null && !(itemStack = (ItemStack)entry.getValue()).func_190926_b() && itemStack.func_77951_h()) {
            int i = Math.min(GenericHandler.xpToDurability(event.getOrb().field_70530_e), itemStack.func_77952_i());
            event.getOrb().field_70530_e -= GenericHandler.durabilityToXp(i);
            itemStack.func_196085_b(itemStack.func_77952_i() - i);
        }
        if (!player.func_130014_f_().field_72995_K) {
            for (ItemStack stack : InventoryHelper.getAllInventories(player)) {
                if (!(stack.func_77973_b() instanceof ItemExperienceBook)) continue;
                ItemExperienceBook.addExperience(stack, event.getOrb().field_70530_e);
                event.getOrb().field_70530_e = 0;
                break;
            }
        }
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    public static void sendPlayerDemonWillAura(PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            BlockPos pos = player.func_233580_cy_();
            DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(WorldDemonWillHandler.getDimensionResourceLocation(player.field_70170_p), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (holder != null) {
                BloodMagic.packetHandler.sendTo(new DemonAuraClientPacket(holder), (ServerPlayerEntity)player);
            } else {
                BloodMagic.packetHandler.sendTo(new DemonAuraClientPacket(new DemonWillHolder()), (ServerPlayerEntity)player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && (entity = event.getEntityLiving()).func_70644_a(BloodMagicPotions.PLANT_LEECH)) {
            int amplifier = entity.func_70660_b(BloodMagicPotions.PLANT_LEECH).func_76458_c();
            int timeRemaining = entity.func_70660_b(BloodMagicPotions.PLANT_LEECH).func_76459_b();
            if (timeRemaining % 10 == 0) {
                BMPotionUtils.damageMobAndGrowSurroundingPlants(entity, 2 + amplifier, 1, 1.5 / (double)(amplifier + 3), 25 * (1 + amplifier));
            }
        }
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        PlayerEntity player;
        LivingEntity living = event.getEntityLiving();
        if (living instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)living)) {
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_HEALTH.get()), event.getAmount());
        }
    }

    @SubscribeEvent
    public void onSelfSacrifice(SacrificeKnifeUsedEvent event) {
        if (LivingUtil.hasFullSet(event.player)) {
            LivingStats stats = LivingStats.fromPlayer(event.player, true);
            double bonus = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get())).getBonusValue("self_mod", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get())).getKey())).doubleValue();
            event.lpAdded = (int)Math.round((double)event.lpAdded * (1.0 + bonus));
            LivingUtil.applyNewExperience(event.player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get()), event.healthDrained);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        if (event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)event.getEntityLiving())) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            if (!player.func_233570_aj_() && player.func_213322_ci().func_82617_b() < 0.0) {
                int jumpLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey());
                double fallDistanceMultiplier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("fall", jumpLevel).doubleValue();
                player.field_70143_R = (float)Math.max(0.0, (double)player.field_70143_R + fallDistanceMultiplier * player.func_213322_ci().func_82617_b());
            }
            return;
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getEntityLiving();
            float percentIncrease = 0.0f;
            if (LivingUtil.hasFullSet(player)) {
                int fireCooldown;
                int fireLevel;
                int speedTime;
                LivingStats stats = LivingStats.fromPlayer(player, true);
                ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
                if (player.func_70051_ag() && (speedTime = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getBonusValue("speed_time", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getKey())).intValue()) > 0) {
                    int speedLevel = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getBonusValue("speed_level", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getKey())).intValue();
                    player.func_195064_c(new EffectInstance(Effects.field_76424_c, speedTime, speedLevel, true, false));
                }
                double distance = 0.0;
                if (posXMap.containsKey(player.func_110124_au())) {
                    distance = Math.sqrt((player.func_226277_ct_() - posXMap.get(player.func_110124_au())) * (player.func_226277_ct_() - posXMap.get(player.func_110124_au())) + (player.func_226281_cx_() - posZMap.get(player.func_110124_au())) * (player.func_226281_cx_() - posZMap.get(player.func_110124_au())));
                }
                int currentFood = player.func_71024_bL().func_75116_a();
                if (foodMap.getOrDefault(player.func_110124_au(), 19) < currentFood) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_KNOCKBACK_RESIST.get()), currentFood - foodMap.getOrDefault(player.func_110124_au(), 19));
                }
                foodMap.put(player.func_110124_au(), currentFood);
                if (player.func_233570_aj_() && distance > 0.0 && distance < 50.0) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get()), distance *= (double)(1.0f + percentIncrease));
                }
                if (!player.func_233570_aj_() && player.func_213322_ci().func_82617_b() < 0.0) {
                    int jumpLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey());
                    double fallDistanceMultiplier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("fall", jumpLevel).doubleValue();
                    player.field_70143_R = (float)Math.max(0.0, (double)player.field_70143_R + fallDistanceMultiplier * player.func_213322_ci().func_82617_b());
                }
                if ((fireLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getKey())) > 0) {
                    boolean hasChanged = false;
                    fireCooldown = chestStack.func_77978_p().func_74762_e("fire_cooldown");
                    if (fireCooldown > 0) {
                        --fireCooldown;
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        chestStack.func_77978_p().func_74768_a("fire_cooldown", fireCooldown);
                    }
                }
                if (player.func_223314_ad() > 0) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get()), 1.0);
                    if (fireLevel > 0) {
                        boolean hasChanged = false;
                        fireCooldown = chestStack.func_77978_p().func_74762_e("fire_cooldown");
                        if (player.func_223314_ad() > 0 && fireCooldown <= 0) {
                            fireCooldown = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getBonusValue("cooldown_time", fireLevel).intValue();
                            player.func_195064_c(new EffectInstance(Effects.field_76426_n, ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getBonusValue("resist_duration", fireLevel).intValue(), 0, true, false));
                            hasChanged = true;
                        }
                        if (hasChanged) {
                            chestStack.func_77978_p().func_74768_a("fire_cooldown", fireCooldown);
                        }
                    }
                }
                int poisonLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getKey());
                if (player.func_70644_a(Effects.field_76436_u)) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get()), 1.0);
                }
                if (poisonLevel > 0) {
                    boolean hasChanged = false;
                    int poisonCooldown = chestStack.func_77978_p().func_74762_e("poison_cooldown");
                    if (poisonCooldown > 0) {
                        --poisonCooldown;
                        hasChanged = true;
                    }
                    if (player.func_70644_a(Effects.field_76436_u) && poisonCooldown <= 0 && ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getBonusValue("max_cure", poisonLevel).intValue() >= player.func_70660_b(Effects.field_76436_u).func_76458_c()) {
                        poisonCooldown = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getBonusValue("cooldown", poisonLevel).intValue();
                        player.func_195063_d(Effects.field_76436_u);
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        chestStack.func_77978_p().func_74768_a("poison_cooldown", poisonCooldown);
                    }
                }
            }
            posXMap.put(player.func_110124_au(), player.func_226277_ct_());
            posZMap.put(player.func_110124_au(), player.func_226281_cx_());
        }
    }

    @SubscribeEvent
    public void onMiningSpeedCheck(PlayerEvent.BreakSpeed event) {
        PlayerEntity player = event.getPlayer();
        float percentIncrease = 0.0f;
        if (LivingUtil.hasFullSet(player)) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            percentIncrease = (float)((double)percentIncrease + ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_modifier", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).doubleValue());
        }
        event.setNewSpeed((1.0f + percentIncrease) * event.getNewSpeed());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            ItemStack heldStack;
            AnointmentHolder holder;
            if (LivingUtil.hasFullSet(player)) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get()), 1.0);
                LivingStats stats = LivingStats.fromPlayer(player);
                int mineTime = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_time", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).intValue();
                if (mineTime > 0) {
                    player.func_195064_c(new EffectInstance(Effects.field_76422_e, mineTime, ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_level", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).intValue(), true, false));
                }
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = player.func_184614_ca())) != null) {
                int hiddenLevel;
                if (holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())) >= 1) {
                    int bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                    int exp = event.getState().getExpDrop((IWorldReader)event.getWorld(), event.getPos(), bonusLevel, holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())));
                    event.setExpToDrop(exp);
                }
                if ((hiddenLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_HIDDEN_KNOWLEDGE.get()))) > 0) {
                    double expBonus = ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_HIDDEN_KNOWLEDGE.get())).getBonusValue("exp", hiddenLevel).doubleValue();
                    int expAdded = (int)expBonus + (expBonus % 1.0 > event.getWorld().func_201674_k().nextDouble() ? 1 : 0);
                    event.setExpToDrop(event.getExpToDrop() + expAdded);
                }
                if (holder.consumeAnointmentDurabilityOnHarvest(heldStack, EquipmentSlotType.MAINHAND, (LivingEntity)player)) {
                    holder.toItemStack(heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && LivingUtil.hasFullSet(player = (PlayerEntity)event.getEntityLiving())) {
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get()), 1.0);
            if (!player.func_225608_bj_()) {
                LivingStats stats = LivingStats.fromPlayer(player);
                double jumpModifier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("jump", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey())).doubleValue();
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, jumpModifier, 0.0));
            }
        }
    }

    @SubscribeEvent
    public void onEntityUseTick(LivingEntityUseItemEvent.Tick event) {
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() instanceof BowItem || stack.func_77973_b() instanceof CrossbowItem) {
            AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
            if (holder == null) {
                return;
            }
            int quickDrawLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_QUICK_DRAW.get()));
            if (quickDrawLevel > 0) {
                double amount = rollMap.getOrDefault(stack, 0.0) + ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_QUICK_DRAW.get())).getBonusValue("speed", quickDrawLevel).doubleValue();
                if (amount >= 1.0) {
                    int drawReduction = (int)amount;
                    event.setDuration(event.getDuration() - drawReduction);
                } else {
                    rollMap.put(stack, amount);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityFinishUse(LivingEntityUseItemEvent.Stop event) {
        int i;
        float f;
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() instanceof CrossbowItem && (f = GenericHandler.getCharge(i = stack.func_77988_m() - event.getDuration(), stack)) < 0.0f) {
            return;
        }
        AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
        if (holder != null && holder.consumeAnointmentDurabilityOnUseFinish(stack, EquipmentSlotType.MAINHAND, event.getEntityLiving())) {
            holder.toItemStack(stack);
        }
    }

    @SubscribeEvent
    public void onEntityJoinEvent(EntityJoinWorldEvent event) {
        ArrowEntity arrowEntity;
        Entity shooter;
        Entity entity = event.getEntity();
        if (entity instanceof ArrowEntity && entity.field_70173_aa <= 0 && (shooter = (arrowEntity = (ArrowEntity)entity).func_234616_v_()) instanceof PlayerEntity) {
            PlayerEntity playerShooter = (PlayerEntity)shooter;
            for (Hand hand : Hand.values()) {
                int velocityLevel;
                ItemStack heldStack = playerShooter.func_184586_b(hand);
                AnointmentHolder holder = AnointmentHolder.fromItemStack(heldStack);
                if (holder == null) continue;
                int powerLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_POWER.get()));
                if (powerLevel > 0) {
                    arrowEntity.func_70239_b(arrowEntity.func_70242_d() * ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_POWER.get())).getBonusValue("damage", powerLevel).doubleValue());
                }
                if ((velocityLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_VELOCITY.get()))) <= 0) break;
                Vector3d motion = arrowEntity.func_213322_ci();
                double multiplier = (float)((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_VELOCITY.get())).getBonusValue("multiplier", velocityLevel).doubleValue();
                arrowEntity.func_213317_d(motion.func_186678_a(multiplier));
                arrowEntity.func_70239_b(arrowEntity.func_70242_d() / multiplier);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onCheckLooting(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source == null) {
            return;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof PlayerEntity) {
            ItemStack heldStack = ((PlayerEntity)entity).func_184614_ca();
            AnointmentHolder holder = AnointmentHolder.fromItemStack(heldStack);
            if (holder == null) {
                return;
            }
            int plunderLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_LOOTING.get()));
            if (plunderLevel > 0) {
                event.setLootingLevel(event.getLootingLevel() + plunderLevel);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity entity;
        if (BloodMagic.curiosLoaded.booleanValue() && (event.getFrom().func_77973_b() instanceof ItemLivingArmor || event.getTo().func_77973_b() instanceof ItemLivingArmor) && (entity = event.getEntityLiving()) instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            UUID uuid = player.func_110124_au();
            if (LivingUtil.hasFullSet(player)) {
                LivingStats stats = LivingStats.fromPlayer(player);
                if (stats != null) {
                    int curiosLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_CURIOS_SOCKET.get())).getKey());
                    if (curiosLevelMap.getOrDefault(uuid, 0) != curiosLevel) {
                        curiosLevelMap.put(uuid, BloodMagic.curiosCompat.recalculateCuriosSlots(player));
                    }
                } else if (curiosLevelMap.getOrDefault(uuid, 0) != 0) {
                    curiosLevelMap.put(uuid, 0);
                }
            } else if (curiosLevelMap.getOrDefault(uuid, 0) != 0) {
                curiosLevelMap.put(uuid, BloodMagic.curiosCompat.recalculateCuriosSlots(player));
            }
        }
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)GenericHandler.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeTime(ItemStack stack) {
        int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
        return i == 0 ? 25 : 25 - 5 * i;
    }
}

