/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wayoftime.bloodmagic.api.compat.IDemonWillViewer;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class Utils {
    public static boolean insertItemToTile(TileInventory tile, PlayerEntity player) {
        return Utils.insertItemToTile(tile, player, 0);
    }

    public static boolean insertItemToTile(TileInventory tile, PlayerEntity player, int slot) {
        ItemStack slotStack = tile.func_70301_a(slot);
        if (slotStack.func_190926_b() && !player.func_184614_ca().func_190926_b()) {
            ItemStack input = player.func_184614_ca().func_77946_l();
            input.func_190920_e(1);
            player.func_184614_ca().func_190918_g(1);
            tile.func_70299_a(slot, input);
            return true;
        }
        if (!slotStack.func_190926_b() && player.func_184614_ca().func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)slotStack);
            tile.func_174888_l();
            return false;
        }
        return false;
    }

    public static String toFancyCasing(String input) {
        return String.valueOf(input.charAt(0)).toUpperCase(Locale.ENGLISH) + input.substring(1);
    }

    public static boolean isImmuneToFireDamage(LivingEntity entity) {
        return entity.func_230279_az_() || entity.func_70644_a(Effects.field_76426_n);
    }

    public static boolean isBlockLiquid(BlockState state) {
        return state instanceof IFluidBlock || state.func_185904_a().func_76224_d();
    }

    public static boolean isFlowingLiquid(World world, BlockPos pos, BlockState state) {
        Block block = state.func_177230_c();
        return block instanceof IFluidBlock && Math.abs(((IFluidBlock)block).getFilledPercentage(world, pos)) == 1.0f || block instanceof FlowingFluidBlock && !((FlowingFluidBlock)block).func_204507_t(state).func_206889_d();
    }

    public static boolean spawnStackAtBlock(World world, BlockPos pos, @Nullable Direction pushDirection, ItemStack stack) {
        BlockPos spawnPos = new BlockPos((Vector3i)pos);
        double velX = 0.0;
        double velY = 0.0;
        double velZ = 0.0;
        double velocity = 0.15;
        if (pushDirection != null) {
            spawnPos = spawnPos.func_177972_a(pushDirection);
            switch (pushDirection) {
                case DOWN: {
                    velY = -velocity;
                    break;
                }
                case UP: {
                    velY = velocity;
                    break;
                }
                case NORTH: {
                    velZ = -velocity;
                    break;
                }
                case SOUTH: {
                    velZ = velocity;
                    break;
                }
                case WEST: {
                    velX = -velocity;
                    break;
                }
                case EAST: {
                    velX = velocity;
                }
            }
        }
        double posX = (double)spawnPos.func_177958_n() + 0.5;
        double posY = (double)spawnPos.func_177956_o() + 0.5;
        double posZ = (double)spawnPos.func_177952_p() + 0.5;
        ItemEntity entityItem = new ItemEntity(world, posX, posY, posZ, stack);
        entityItem.func_213293_j(velX, velY, velZ);
        entityItem.func_92058_a(stack);
        return world.func_217376_c((Entity)entityItem);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos) {
        return Utils.swapLocations(initialWorld, initialPos, finalWorld, finalPos, true);
    }

    public static boolean swapLocations(World initialWorld, BlockPos initialPos, World finalWorld, BlockPos finalPos, boolean playSound) {
        TileEntity initialTile = initialWorld.func_175625_s(initialPos);
        TileEntity finalTile = finalWorld.func_175625_s(finalPos);
        CompoundNBT initialTag = new CompoundNBT();
        CompoundNBT finalTag = new CompoundNBT();
        if (initialTile != null) {
            initialTile.func_189515_b(initialTag);
        }
        if (finalTile != null) {
            finalTile.func_189515_b(finalTag);
        }
        BlockState initialState = initialWorld.func_180495_p(initialPos);
        BlockState finalState = finalWorld.func_180495_p(finalPos);
        if (initialState.func_177230_c().equals(Blocks.field_150350_a) && finalState.func_177230_c().equals(Blocks.field_150350_a) || initialState.func_177230_c() instanceof NetherPortalBlock || finalState.func_177230_c() instanceof NetherPortalBlock) {
            return false;
        }
        if (playSound) {
            initialWorld.func_184148_a(null, (double)initialPos.func_177958_n(), (double)initialPos.func_177956_o(), (double)initialPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f);
            finalWorld.func_184148_a(null, (double)finalPos.func_177958_n(), (double)finalPos.func_177956_o(), (double)finalPos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
        if (finalState.func_177230_c().hasTileEntity(finalState)) {
            finalWorld.func_175713_t(finalPos);
        }
        if (initialState.func_177230_c().hasTileEntity(initialState)) {
            initialWorld.func_175713_t(initialPos);
        }
        BlockState initialBlockState = initialWorld.func_180495_p(initialPos);
        BlockState finalBlockState = finalWorld.func_180495_p(finalPos);
        finalWorld.func_180501_a(finalPos, initialBlockState, 3);
        if (initialTile != null) {
            TileEntity newTileInitial = TileEntity.func_235657_b_((BlockState)finalBlockState, (CompoundNBT)initialTag);
            finalWorld.func_175690_a(finalPos, newTileInitial);
            newTileInitial.func_226984_a_(finalWorld, finalPos);
        }
        initialWorld.func_180501_a(initialPos, finalBlockState, 3);
        if (finalTile != null) {
            TileEntity newTileFinal = TileEntity.func_235657_b_((BlockState)initialBlockState, (CompoundNBT)finalTag);
            initialWorld.func_175690_a(initialPos, newTileFinal);
            newTileFinal.func_226984_a_(initialWorld, initialPos);
        }
        initialWorld.func_195593_d(initialPos, finalState.func_177230_c());
        finalWorld.func_195593_d(finalPos, initialState.func_177230_c());
        return true;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, TileEntity tile, Direction dir) {
        LazyOptional capability = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
        if (capability.isPresent()) {
            IItemHandler handler = (IItemHandler)capability.resolve().get();
            return Utils.insertStackIntoTile(stack, handler);
        }
        if (tile instanceof IInventory) {
            return Utils.insertStackIntoInventory(stack, (IInventory)tile, dir);
        }
        return stack;
    }

    public static ItemStack insertStackIntoTile(ItemStack stack, IItemHandler handler) {
        int numberOfSlots = handler.getSlots();
        ItemStack copyStack = stack.func_77946_l();
        for (int slot = 0; slot < numberOfSlots; ++slot) {
            if (!(copyStack = handler.insertItem(slot, copyStack, false)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return copyStack;
    }

    public static int getNumberOfFreeSlots(TileEntity tile, Direction dir) {
        int slots;
        block3: {
            block2: {
                slots = 0;
                LazyOptional capability = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
                if (!capability.isPresent()) break block2;
                IItemHandler handler = (IItemHandler)capability.resolve().get();
                for (int i = 0; i < handler.getSlots(); ++i) {
                    if (!handler.getStackInSlot(i).func_190926_b()) continue;
                    ++slots;
                }
                break block3;
            }
            if (!(tile instanceof IInventory)) break block3;
            for (int i = 0; i < ((IInventory)tile).func_70302_i_(); ++i) {
                if (!((IInventory)tile).func_70301_a(i).func_190926_b()) continue;
                ++slots;
            }
        }
        return slots;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inventory, Direction dir) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack[] combinedStacks = Utils.combineStacks(stack, inventory.func_70301_a(i));
            stack = combinedStacks[0];
            inventory.func_70299_a(i, combinedStacks[1]);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static boolean canInsertStackFullyIntoInventory(ItemStack stack, IInventory inventory, Direction dir, boolean fillToLimit, int limit) {
        if (stack.func_190926_b()) {
            return true;
        }
        int itemsLeft = stack.func_190916_E();
        boolean[] canBeInserted = new boolean[inventory.func_70302_i_()];
        if (inventory instanceof ISidedInventory) {
            int[] array;
            for (int in : array = ((ISidedInventory)inventory).func_180463_a(dir)) {
                canBeInserted[in] = inventory.func_94041_b(in, stack) && ((ISidedInventory)inventory).func_180462_a(in, stack, dir);
            }
        } else {
            for (int i = 0; i < canBeInserted.length; ++i) {
                canBeInserted[i] = inventory.func_94041_b(i, stack);
            }
        }
        int numberMatching = 0;
        if (fillToLimit) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack invStack;
                if (!canBeInserted[i] || (invStack = inventory.func_70301_a(i)).func_190926_b() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack)) continue;
                numberMatching += invStack.func_190916_E();
            }
        }
        if (fillToLimit && limit < stack.func_190916_E() + numberMatching) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!canBeInserted[i]) continue;
            ItemStack invStack = inventory.func_70301_a(i);
            boolean canCombine = ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)invStack);
            if (canCombine) {
                itemsLeft = invStack.func_190926_b() ? 0 : (itemsLeft -= invStack.func_77976_d() - invStack.func_190916_E());
            }
            if (itemsLeft > 0) continue;
            return true;
        }
        return false;
    }

    public static ItemStack[] combineStacks(ItemStack stack1, ItemStack stack2) {
        ItemStack[] returned = new ItemStack[2];
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2)) {
            int transferedAmount;
            int n = transferedAmount = stack2.func_190926_b() ? stack1.func_190916_E() : Math.min(stack2.func_77976_d() - stack2.func_190916_E(), stack1.func_190916_E());
            if (transferedAmount > 0) {
                ItemStack copyStack = stack1.func_77979_a(transferedAmount);
                if (stack2.func_190926_b()) {
                    stack2 = copyStack;
                } else {
                    stack2.func_190917_f(transferedAmount);
                }
            }
        }
        returned[0] = stack1;
        returned[1] = stack2;
        return returned;
    }

    public static boolean canPlayerSeeDemonWill(PlayerEntity player) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), stack, player)) continue;
            return true;
        }
        ItemStack offhandStack = player.func_184592_cb();
        return !offhandStack.func_190926_b() && offhandStack.func_77973_b() instanceof IDemonWillViewer && ((IDemonWillViewer)offhandStack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), offhandStack, player);
    }

    public static double getDemonWillResolution(PlayerEntity player) {
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillViewer) || !((IDemonWillViewer)stack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), stack, player)) continue;
            return ((IDemonWillViewer)stack.func_77973_b()).getDemonWillAuraResolution(player.func_130014_f_(), stack, player);
        }
        ItemStack offhandStack = player.func_184592_cb();
        if (!offhandStack.func_190926_b() && offhandStack.func_77973_b() instanceof IDemonWillViewer && ((IDemonWillViewer)offhandStack.func_77973_b()).canSeeDemonWillAura(player.func_130014_f_(), offhandStack, player)) {
            return ((IDemonWillViewer)offhandStack.func_77973_b()).getDemonWillAuraResolution(player.func_130014_f_(), offhandStack, player);
        }
        return 100.0;
    }

    public static int plantSeedsInArea(World world, AxisAlignedBB aabb, int horizontalRadius, int verticalRadius) {
        int placedBlocks = 0;
        List itemEntities = world.func_217357_a(ItemEntity.class, aabb);
        for (ItemEntity itemEntity : itemEntities) {
            placedBlocks += Utils.plantEntityItem(itemEntity, horizontalRadius, verticalRadius);
        }
        return placedBlocks;
    }

    public static int plantItemStack(World world, BlockPos centralPos, ItemStack stack, int horizontalRadius, int verticalRadius) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof IPlantable)) {
            return 0;
        }
        int planted = 0;
        for (int hR = 0; hR <= horizontalRadius; ++hR) {
            for (int vR = 0; vR <= verticalRadius; ++vR) {
                for (int i = -hR; i <= hR; ++i) {
                    for (int k = -hR; k <= hR; ++k) {
                        for (int j = -vR; j <= vR; j += 2 * vR + (vR > 0 ? 0 : 1)) {
                            BlockPos offsetPos;
                            BlockState state;
                            BlockPos newPos;
                            if (Math.abs(i) != hR && Math.abs(k) != hR || !world.func_175623_d(newPos = centralPos.func_177982_a(i, j, k)) || !(state = world.func_180495_p(offsetPos = newPos.func_177972_a(Direction.DOWN))).func_177230_c().canSustainPlant(state, (IBlockReader)world, offsetPos, Direction.UP, (IPlantable)item)) continue;
                            BlockState plantState = ((IPlantable)item).getPlant((IBlockReader)world, newPos);
                            world.func_180501_a(newPos, plantState, 3);
                            world.func_217379_c(2001, newPos, Block.func_196246_j((BlockState)plantState));
                            stack.func_190918_g(1);
                            ++planted;
                            if (!stack.func_190926_b() && stack.func_190916_E() > 0) continue;
                            return planted;
                        }
                    }
                }
            }
        }
        return planted;
    }

    public static int plantEntityItem(ItemEntity itemEntity, int horizontalRadius, int verticalRadius) {
        if (itemEntity == null || !itemEntity.func_70089_S()) {
            return 0;
        }
        World world = itemEntity.func_130014_f_();
        BlockPos pos = itemEntity.func_233580_cy_();
        ItemStack stack = itemEntity.func_92059_d();
        int planted = Utils.plantItemStack(world, pos, stack, horizontalRadius, verticalRadius);
        if (stack.func_190926_b()) {
            itemEntity.func_70106_y();
        }
        return planted;
    }

    @Nullable
    public static IItemHandler getInventory(TileEntity tile, @Nullable Direction facing) {
        if (facing == null) {
            facing = Direction.DOWN;
        }
        IItemHandler itemHandler = null;
        if (tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).isPresent()) {
            itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing).resolve().get();
        } else if (tile instanceof ISidedInventory) {
            itemHandler = ((ISidedInventory)tile).func_180463_a(facing).length != 0 ? new SidedInvWrapper((ISidedInventory)tile, facing) : null;
        } else if (tile instanceof IInventory) {
            itemHandler = new InvWrapper((IInventory)tile);
        }
        return itemHandler;
    }

    public static float addAbsorptionToMaximum(LivingEntity entity, float added, int maximum, int duration) {
        float currentAmount = entity.func_110139_bj();
        added = Math.min((float)maximum - currentAmount, added);
        if (added <= 0.0f) {
            return 0.0f;
        }
        if (duration > 0) {
            int potionLevel = (int)((currentAmount + added) / 4.0f);
            entity.func_195064_c(new EffectInstance(Effects.field_76444_x, duration, potionLevel, true, false));
        }
        entity.func_110149_m(currentAmount + added);
        return added;
    }

    public static boolean hasUUID(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("mostSig") && stack.func_77978_p().func_74764_b("leastSig");
    }

    public static UUID getUUID(ItemStack stack) {
        if (!Utils.hasUUID(stack)) {
            return null;
        }
        return new UUID(stack.func_77978_p().func_74763_f("mostSig"), stack.func_77978_p().func_74763_f("leastSig"));
    }

    public static void setUUID(ItemStack stack) {
        if (!(stack = NBTHelper.checkNBT(stack)).func_77978_p().func_74764_b("mostSig") && !stack.func_77978_p().func_74764_b("leastSig")) {
            UUID itemUUID = UUID.randomUUID();
            stack.func_77978_p().func_74772_a("mostSig", itemUUID.getMostSignificantBits());
            stack.func_77978_p().func_74772_a("leastSig", itemUUID.getLeastSignificantBits());
        }
    }
}

