/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util;

import java.text.DecimalFormat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ChatUtil {
    private static final int DELETION_ID = 2525277;
    private static int lastAdded;
    public static final DecimalFormat DECIMAL_FORMAT;

    private static void sendNoSpamMessages(ITextComponent[] messages) {
        NewChatGui chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        for (int i = 0; i < messages.length; ++i) {
            chat.func_146227_a(messages[i]);
        }
        lastAdded = 2525277 + messages.length - 1;
    }

    public static ITextComponent wrap(String s) {
        return new StringTextComponent(s);
    }

    public static ITextComponent[] wrap(String ... s) {
        ITextComponent[] ret = new ITextComponent[s.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ChatUtil.wrap(s[i]);
        }
        return ret;
    }

    public static ITextComponent wrapFormatted(String s, Object ... args) {
        return new TranslationTextComponent(s, args);
    }

    public static void sendChat(PlayerEntity player, String ... lines) {
        ChatUtil.sendChat(player, ChatUtil.wrap(lines));
    }

    public static void sendChatUnloc(PlayerEntity player, String ... unlocLines) {
        ChatUtil.sendChat(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendChat(PlayerEntity player, ITextComponent ... lines) {
        for (ITextComponent c : lines) {
            player.func_145747_a(c, Util.field_240973_b_);
        }
    }

    public static void sendNoSpamClientUnloc(String ... unlocLines) {
        ChatUtil.sendNoSpamClient(TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpamClient(String ... lines) {
        ChatUtil.sendNoSpamClient(ChatUtil.wrap(lines));
    }

    public static void sendNoSpamClient(ITextComponent ... lines) {
        ChatUtil.sendNoSpamMessages(lines);
    }

    public static void sendNoSpamUnloc(PlayerEntity player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(PlayerEntity player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(PlayerEntity player, ITextComponent ... lines) {
        if (player instanceof ServerPlayerEntity) {
            ChatUtil.sendNoSpam((ServerPlayerEntity)player, lines);
        }
    }

    public static void sendNoSpamUnloc(ServerPlayerEntity player, String ... unlocLines) {
        ChatUtil.sendNoSpam(player, TextHelper.localizeAll(unlocLines));
    }

    public static void sendNoSpam(ServerPlayerEntity player, String ... lines) {
        ChatUtil.sendNoSpam(player, ChatUtil.wrap(lines));
    }

    public static void sendNoSpam(ServerPlayerEntity player, ITextComponent ... lines) {
        if (lines.length > 0) {
            BloodMagic.packetHandler.sendTo(new PacketNoSpamChat(lines), player);
        }
    }

    static {
        DECIMAL_FORMAT = new DecimalFormat("###,###.##");
    }

    public static class PacketNoSpamChat {
        private ITextComponent[] chatLines;

        public PacketNoSpamChat() {
            this.chatLines = new ITextComponent[0];
        }

        private PacketNoSpamChat(ITextComponent ... lines) {
            this.chatLines = lines;
        }

        public static void encode(PacketNoSpamChat pkt, PacketBuffer buf) {
            buf.writeInt(pkt.chatLines.length);
            for (ITextComponent c : pkt.chatLines) {
                buf.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)c));
            }
        }

        public static PacketNoSpamChat decode(PacketBuffer buf) {
            PacketNoSpamChat pkt = new PacketNoSpamChat(new ITextComponent[buf.readInt()]);
            for (int i = 0; i < pkt.chatLines.length; ++i) {
                pkt.chatLines[i] = ITextComponent.Serializer.func_240644_b_((String)buf.func_218666_n());
            }
            return pkt;
        }

        public static void handle(PacketNoSpamChat message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> ChatUtil.sendNoSpamMessages(message.chatLines));
            context.get().setPacketHandled(true);
        }
    }
}

