/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.item.routing.ICompositeItemFilterProvider;
import wayoftime.bloodmagic.common.item.routing.INestableItemFilterProvider;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;

public class RecipeFilterMergeAlchemyTable
extends RecipeAlchemyTable {
    final Ingredient filterIngredient;

    public RecipeFilterMergeAlchemyTable(ResourceLocation id, Ingredient filterIngredient, List<Ingredient> input, ItemStack output, int syphon, int ticks, int minimumTier) {
        super(id, input, output, syphon, ticks, minimumTier);
        this.filterIngredient = filterIngredient;
    }

    @Override
    @Nonnull
    public ItemStack getOutput(List<ItemStack> inputs) {
        int index = -1;
        for (int i = 0; i < inputs.size(); ++i) {
            if (!this.filterIngredient.test(inputs.get(i))) continue;
            index = i;
        }
        if (index == -1) {
            return ItemStack.field_190927_a;
        }
        ItemStack filterStack = inputs.get(index);
        if (!(filterStack.func_77973_b() instanceof ICompositeItemFilterProvider)) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack inputStack;
            if (i == index || inputs.get(i).func_190926_b() || !((inputStack = inputs.get(i)).func_77973_b() instanceof INestableItemFilterProvider) || !((ICompositeItemFilterProvider)filterStack.func_77973_b()).canReceiveNestedFilter(filterStack, inputStack)) continue;
            filterStack = ((ICompositeItemFilterProvider)filterStack.func_77973_b()).nestFilter(filterStack, inputStack);
        }
        return filterStack;
    }

    @Override
    public List<Ingredient> getInput() {
        ArrayList<Ingredient> returnInputs = new ArrayList<Ingredient>(this.input);
        returnInputs.add(this.filterIngredient);
        return returnInputs;
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.filterIngredient.func_199564_a(buffer);
        super.write(buffer);
    }

    public IRecipeSerializer<RecipeFilterMergeAlchemyTable> func_199559_b() {
        return BloodMagicRecipeSerializers.FILTERALCHEMYTABLE.getRecipeSerializer();
    }
}

