/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import wayoftime.bloodmagic.tile.TileAlchemyTable;

public class AlchemyTableFlagPacket {
    private BlockPos pos;
    private boolean orbFlag;
    private boolean lpFlag;

    public AlchemyTableFlagPacket() {
        this.pos = BlockPos.field_177992_a;
        this.orbFlag = false;
        this.lpFlag = false;
    }

    public AlchemyTableFlagPacket(TileAlchemyTable tile) {
        this(tile.func_174877_v(), tile.getOrbFlagForGui(), tile.getLPFlagforGui());
    }

    public AlchemyTableFlagPacket(BlockPos pos, boolean orbFlag, boolean lpFlag) {
        this.pos = pos;
        this.orbFlag = orbFlag;
        this.lpFlag = lpFlag;
    }

    public static void encode(AlchemyTableFlagPacket pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeBoolean(pkt.orbFlag);
        buf.writeBoolean(pkt.lpFlag);
    }

    public static AlchemyTableFlagPacket decode(PacketBuffer buf) {
        AlchemyTableFlagPacket pkt = new AlchemyTableFlagPacket(buf.func_179259_c(), buf.readBoolean(), buf.readBoolean());
        return pkt;
    }

    public static void handle(AlchemyTableFlagPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> AlchemyTableFlagPacket.updateTanks(message.pos, message.orbFlag, message.lpFlag));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateTanks(BlockPos pos, boolean orbFlag, boolean lpFlag) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAlchemyTable) {
            ((TileAlchemyTable)tile).setOrbFlagForGui(orbFlag);
            ((TileAlchemyTable)tile).setLPFlagForGui(lpFlag);
            if (!orbFlag && !lpFlag) {
                ((TileAlchemyTable)tile).burnTime = 0;
            }
        }
    }
}

