/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.living;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wayoftime.bloodmagic.core.living.LivingStats;

@JsonAdapter(value=Deserializer.class)
public class LivingUpgrade
extends ForgeRegistryEntry<LivingUpgrade> {
    public static final LivingUpgrade DUMMY = new LivingUpgrade(new ResourceLocation("dummy"), levels -> levels.add(new Level(0, 0)));
    private final ResourceLocation key;
    private final Set<ResourceLocation> incompatible;
    private final TreeMap<Integer, Integer> experienceToLevel;
    private final Map<Integer, Integer> levelToCost;
    private final Map<String, Bonus> bonuses;
    private boolean isNegative;
    private String translationKey = null;
    private IAttributeProvider attributeProvider;
    private IArmorProvider armorProvider;
    private IDamageProvider damageProvider;

    public LivingUpgrade(ResourceLocation key, Consumer<List<Level>> experienceMapper) {
        this.key = key;
        this.incompatible = Sets.newHashSet();
        this.experienceToLevel = Maps.newTreeMap();
        this.levelToCost = Maps.newHashMap();
        this.bonuses = Maps.newHashMap();
        ArrayList levels = Lists.newArrayList();
        experienceMapper.accept(levels);
        for (int i = 0; i < levels.size(); ++i) {
            Level level = (Level)levels.get(i);
            this.experienceToLevel.put(level.experienceNeeded, i + 1);
            this.levelToCost.put(i + 1, level.upgradeCost);
        }
    }

    public LivingUpgrade withBonusSet(String id, Consumer<List<Number>> modifiers) {
        ArrayList<Number> values2 = new ArrayList<Number>();
        modifiers.accept(values2);
        if (values2.size() != this.levelToCost.size()) {
            throw new RuntimeException("Bonus size and level size must be the same.");
        }
        this.bonuses.put(id, new Bonus(id, values2));
        return this;
    }

    public Number getBonusValue(String id, int level) {
        List modifiers = this.bonuses.getOrDefault(id, Bonus.DEFAULT).modifiers;
        if (modifiers.isEmpty() || level == 0) {
            return 0;
        }
        return (Number)modifiers.get(level - 1);
    }

    public LivingUpgrade withAttributeProvider(IAttributeProvider attributeProvider) {
        this.attributeProvider = attributeProvider;
        return this;
    }

    public IAttributeProvider getAttributeProvider() {
        return this.attributeProvider;
    }

    public LivingUpgrade withArmorProvider(IArmorProvider armorProvider) {
        this.armorProvider = armorProvider;
        return this;
    }

    public IArmorProvider getArmorProvider() {
        return this.armorProvider;
    }

    public LivingUpgrade withDamageProvider(IDamageProvider damageProvider) {
        this.damageProvider = damageProvider;
        return this;
    }

    public IDamageProvider getDamageProvider() {
        return this.damageProvider;
    }

    public String getTranslationKey() {
        return this.translationKey == null ? (this.translationKey = Util.func_200697_a((String)"living_upgrade", (ResourceLocation)this.key)) : this.translationKey;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public boolean isCompatible(ResourceLocation otherUpgrade) {
        return !this.incompatible.contains(otherUpgrade);
    }

    public LivingUpgrade addIncompatibility(ResourceLocation key, ResourceLocation ... otherKeys) {
        this.incompatible.add(key);
        Collections.addAll(this.incompatible, otherKeys);
        return this;
    }

    public int getLevel(int experience) {
        Map.Entry<Integer, Integer> floor = this.experienceToLevel.floorEntry(experience);
        return floor == null ? 0 : floor.getValue();
    }

    public int getNextRequirement(int experience) {
        Integer ret = this.experienceToLevel.ceilingKey(experience + 1);
        return ret == null ? 0 : ret;
    }

    public int getLevelCost(int level) {
        return this.levelToCost.getOrDefault(level, 0);
    }

    public int getLevelExp(int level) {
        for (Map.Entry<Integer, Integer> entry : this.experienceToLevel.entrySet()) {
            if (entry.getValue() != level) continue;
            return entry.getKey();
        }
        return 0;
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public LivingUpgrade asDowngrade() {
        this.isNegative = true;
        return this;
    }

    public String toString() {
        return this.key.toString();
    }

    public static class Level {
        @SerializedName(value="xp")
        private final int experienceNeeded;
        @SerializedName(value="cost")
        private final int upgradeCost;

        public Level(int experienceNeeded, int upgradeCost) {
            this.experienceNeeded = experienceNeeded;
            this.upgradeCost = upgradeCost;
        }
    }

    public static class Bonus {
        private static final Bonus DEFAULT = new Bonus("null", Collections.emptyList());
        private final String id;
        private final List<Number> modifiers;

        public Bonus(String id, List<Number> modifiers) {
            this.id = id;
            this.modifiers = modifiers;
        }

        public String getId() {
            return this.id;
        }
    }

    public static interface IAttributeProvider {
        public void handleAttributes(LivingStats var1, Multimap<Attribute, AttributeModifier> var2, UUID var3, LivingUpgrade var4, int var5);
    }

    public static interface IArmorProvider {
        public double getProtection(PlayerEntity var1, LivingStats var2, DamageSource var3, LivingUpgrade var4, int var5);
    }

    public static interface IDamageProvider {
        public double getAdditionalDamage(PlayerEntity var1, ItemStack var2, double var3, LivingStats var5, LivingEntity var6, LivingUpgrade var7, int var8);
    }

    public static class Deserializer
    implements JsonDeserializer<LivingUpgrade> {
        public LivingUpgrade deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = element.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(json.getAsJsonPrimitive("id").getAsString());
            List levels = (List)context.deserialize((JsonElement)json.getAsJsonArray("levels"), new TypeToken<List<Level>>(){}.getType());
            boolean negative = json.has("negative") && json.getAsJsonPrimitive("negative").getAsBoolean();
            LivingUpgrade upgrade = new LivingUpgrade(id, upgradeLevels -> upgradeLevels.addAll(levels));
            if (negative) {
                upgrade.asDowngrade();
            }
            if (json.has("incompatibilities")) {
                String[] incompatibilities;
                for (String incompatible : incompatibilities = (String[])context.deserialize((JsonElement)json.getAsJsonArray("incompatibilities"), String[].class)) {
                    upgrade.addIncompatibility(new ResourceLocation(incompatible), new ResourceLocation[0]);
                }
            }
            if (json.has("bonuses")) {
                Map bonuses = (Map)context.deserialize((JsonElement)json.getAsJsonObject("bonuses"), new TypeToken<Map<String, Number[]>>(){}.getType());
                bonuses.forEach((k, v) -> upgrade.withBonusSet((String)k, numbers -> Collections.addAll(numbers, v)));
            }
            return upgrade;
        }
    }
}

