/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.array;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.recipe.RecipeAlchemyArray;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class AlchemyArrayCraftingCategory
implements IRecipeCategory<RecipeAlchemyArray> {
    private static final int OUTPUT_SLOT = 0;
    private static final int INPUT_SLOT = 1;
    private static final int CATALYST_SLOT = 2;
    public static final ResourceLocation UID = BloodMagic.rl("alchemyarray");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public AlchemyArrayCraftingCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BloodMagicItems.ARCANE_ASHES.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/binding.png"), 0, 0, 100, 30);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return TextHelper.localize("jei.bloodmagic.recipe.alchemyarraycrafting", new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeAlchemyArray recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        recipeLayout.getItemStacks().init(0, false, 73, 5);
        recipeLayout.getItemStacks().init(1, true, 0, 5);
        recipeLayout.getItemStacks().init(2, true, 29, 3);
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipeAlchemyArray> getRecipeClass() {
        return RecipeAlchemyArray.class;
    }

    public void setIngredients(RecipeAlchemyArray recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        if (recipe.getOutput().func_190926_b()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((IItemProvider)BloodMagicItems.ARCANE_ASHES.get()));
        } else {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
        }
    }
}

