/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.tile.TileIncenseAltar;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.NumeralHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilDivination
extends ItemSigilBase
implements IAltarReader {
    private final boolean isSimple;

    public ItemSigilDivination(boolean simple) {
        super(simple ? "divination" : "seer");
        this.isSimple = simple;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (!world.field_72995_K) {
            BlockRayTraceResult position = Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
            if (position == null || position.func_216346_c() == RayTraceResult.Type.MISS) {
                super.func_77659_a(world, player, hand);
                Binding binding = this.getBinding(stack);
                if (this.isSimple && binding != null) {
                    int currentEssence = NetworkHelper.getSoulNetwork(binding).getCurrentEssence();
                    ArrayList toSend = Lists.newArrayList();
                    if (!binding.getOwnerId().equals(player.func_146103_bH().getId())) {
                        toSend.add(new TranslationTextComponent(this.tooltipBase + "otherNetwork", new Object[]{binding.getOwnerName()}));
                    }
                    toSend.add(new TranslationTextComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}));
                    ChatUtil.sendNoSpam(player, toSend.toArray(new ITextComponent[toSend.size()]));
                }
            } else if (position.func_216346_c() == RayTraceResult.Type.BLOCK) {
                TileEntity tile = world.func_175625_s(new BlockPos(position.func_216347_e()));
                if (tile != null && tile instanceof IBloodAltar) {
                    IBloodAltar altar = (IBloodAltar)tile;
                    int tier = altar.getTier();
                    int currentEssence = altar.getCurrentBlood();
                    int capacity = altar.getCapacity();
                    altar.checkTier();
                    if (this.isSimple) {
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent(this.tooltipBase + "currentAltarTier", new Object[]{NumeralHelper.toRoman(tier)}), new TranslationTextComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}), new TranslationTextComponent(this.tooltipBase + "currentAltarCapacity", new Object[]{capacity})});
                    } else {
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent(this.tooltipBase + "currentAltarTier", new Object[]{NumeralHelper.toRoman(tier)}), new TranslationTextComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}), new TranslationTextComponent(this.tooltipBase + "currentAltarCapacity", new Object[]{capacity})});
                    }
                } else if (tile != null && tile instanceof TileIncenseAltar) {
                    TileIncenseAltar altar = (TileIncenseAltar)tile;
                    altar.recheckConstruction();
                    double tranquility = altar.tranquility;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TranslationTextComponent(this.tooltipBase + "currentTranquility", new Object[]{(int)(100.0 * (double)((int)(100.0 * tranquility)) / 100.0)}), new TranslationTextComponent(this.tooltipBase + "currentBonus", new Object[]{(int)(100.0 * altar.incenseAddition)})});
                } else {
                    Binding binding = this.getBinding(stack);
                    if (binding != null) {
                        int currentEssence = NetworkHelper.getSoulNetwork(binding).getCurrentEssence();
                        ArrayList toSend = Lists.newArrayList();
                        if (!binding.getOwnerId().equals(player.func_146103_bH().getId())) {
                            toSend.add(new TranslationTextComponent(this.tooltipBase + "otherNetwork", new Object[]{binding.getOwnerName()}));
                        }
                        toSend.add(new TranslationTextComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}));
                        ChatUtil.sendNoSpam(player, toSend.toArray(new ITextComponent[toSend.size()]));
                    }
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }
}

