/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.advancementplaques;

import com.anthonyhilyard.advancementplaques.AdvancementPlaques;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesConfig;
import com.anthonyhilyard.advancementplaques.AdvancementPlaquesToastGui;
import com.anthonyhilyard.advancementplaques.Loader;
import com.anthonyhilyard.iceberg.renderer.CustomItemRenderer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.toasts.AdvancementToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;

public class AdvancementPlaque {
    private final AdvancementToast toast;
    private long animationTime = -1L;
    private long visibleTime = -1L;
    private boolean hasPlayedSound = false;
    private IToast.Visibility visibility = IToast.Visibility.SHOW;
    private Minecraft mc;
    private CustomItemRenderer itemRenderer;

    public AdvancementPlaque(AdvancementToast toastIn, Minecraft mcIn, CustomItemRenderer itemRendererIn) {
        this.toast = toastIn;
        this.mc = mcIn;
        this.itemRenderer = itemRendererIn;
    }

    public AdvancementToast getToast() {
        return this.toast;
    }

    public int width() {
        return 256;
    }

    public int height() {
        return 32;
    }

    private float getVisibility(long currentTime) {
        float f = MathHelper.func_76131_a((float)((float)(currentTime - this.animationTime) / 200.0f), (float)0.0f, (float)1.0f);
        f *= f;
        return this.visibility == IToast.Visibility.HIDE ? 1.0f - f : f;
    }

    private IToast.Visibility drawPlaque(MatrixStack matrixStack, long displayTime) {
        DisplayInfo displayInfo = this.toast.field_193679_c.func_192068_c();
        if (displayInfo != null) {
            float alpha;
            float duration;
            float fadeOutTime;
            float fadeInTime;
            switch (displayInfo.func_192291_d()) {
                default: {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskEffectFadeOutTime.get() * 1000.0);
                    duration = (float)((Double)AdvancementPlaquesConfig.INSTANCE.taskDuration.get() * 1000.0);
                    break;
                }
                case GOAL: {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalEffectFadeOutTime.get() * 1000.0);
                    duration = (float)((Double)AdvancementPlaquesConfig.INSTANCE.goalDuration.get() * 1000.0);
                    break;
                }
                case CHALLENGE: {
                    fadeInTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeInTime.get() * 1000.0);
                    fadeOutTime = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeEffectFadeOutTime.get() * 1000.0);
                    duration = (float)((Double)AdvancementPlaquesConfig.INSTANCE.challengeDuration.get() * 1000.0);
                }
            }
            if ((float)displayTime >= fadeInTime) {
                alpha = 1.0f;
                if ((float)displayTime > duration) {
                    alpha = Math.max(0.0f, Math.min(1.0f, 1.0f - ((float)displayTime - duration) / 1000.0f));
                }
                int tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.titleColor.get()).longValue();
                int tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int titleColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                tempColor = (int)((Long)AdvancementPlaquesConfig.INSTANCE.nameColor.get()).longValue();
                tempAlpha = (int)((float)(tempColor >> 24 & 0xFF) * alpha);
                int nameColor = tempColor & 0xFFFFFF | tempAlpha << 24;
                this.mc.func_110434_K().func_110577_a(AdvancementPlaques.TEXTURE_PLAQUES);
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                int frameOffset = 0;
                if (displayInfo.func_192291_d() == FrameType.GOAL) {
                    frameOffset = 1;
                } else if (displayInfo.func_192291_d() == FrameType.CHALLENGE) {
                    frameOffset = 2;
                }
                AdvancementPlaquesToastGui.func_238463_a_((MatrixStack)matrixStack, (int)-1, (int)-1, (float)0.0f, (float)(this.height() * frameOffset), (int)this.width(), (int)this.height(), (int)256, (int)256);
                if (alpha > 0.1f) {
                    int typeWidth = this.mc.field_71466_p.func_238414_a_((ITextProperties)displayInfo.func_192291_d().func_242265_d());
                    this.mc.field_71466_p.func_243248_b(matrixStack, displayInfo.func_192291_d().func_242265_d(), (float)(this.width() - typeWidth) / 2.0f + 15.0f, 5.0f, titleColor);
                    int titleWidth = this.mc.field_71466_p.func_238414_a_((ITextProperties)displayInfo.func_192297_a());
                    if ((float)titleWidth <= 146.66667f) {
                        RenderSystem.pushMatrix();
                        RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.0f);
                        this.mc.field_71466_p.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)displayInfo.func_192297_a()), ((float)this.width() / 1.5f - (float)titleWidth) / 2.0f + 10.0f, 9.0f, nameColor);
                        RenderSystem.popMatrix();
                    } else {
                        this.mc.field_71466_p.func_238422_b_(matrixStack, LanguageMap.func_74808_a().func_241870_a((ITextProperties)displayInfo.func_192297_a()), (float)(this.width() - titleWidth) / 2.0f + 15.0f, 15.0f, nameColor);
                    }
                }
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)1.0f, (float)1.0f, (float)0.0f);
                RenderSystem.scalef((float)1.5f, (float)1.5f, (float)1.0f);
                this.itemRenderer.renderItemModelIntoGUIWithAlpha(displayInfo.func_192298_b(), 1, 1, alpha);
                RenderSystem.popMatrix();
                if (!this.hasPlayedSound) {
                    this.hasPlayedSound = true;
                    try {
                        switch (displayInfo.func_192291_d()) {
                            case TASK: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteTasks.get()).booleanValue()) {
                                    this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)((SoundEvent)AdvancementPlaques.TASK_COMPLETE.get()), (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            case GOAL: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteGoals.get()).booleanValue()) {
                                    this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)((SoundEvent)AdvancementPlaques.GOAL_COMPLETE.get()), (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                            default: {
                                if (!((Boolean)AdvancementPlaquesConfig.INSTANCE.muteChallenges.get()).booleanValue()) {
                                    this.mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_194228_if, (float)1.0f, (float)1.0f));
                                }
                                break;
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        Loader.LOGGER.warn("Tried to play a custom sound for an advancement, but that sound was not registered!  Install Advancement Plaques on the server or mute tasks and goals in the config file.");
                    }
                }
            }
            if ((float)displayTime < fadeInTime + fadeOutTime) {
                alpha = 1.0f - ((float)displayTime - fadeInTime) / fadeOutTime;
                if ((float)displayTime < fadeInTime) {
                    alpha = (float)displayTime / fadeInTime;
                }
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.defaultAlphaFunc();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 0.0, 95.0);
                this.mc.func_110434_K().func_110577_a(AdvancementPlaques.TEXTURE_PLAQUE_EFFECTS);
                if (displayInfo.func_192291_d() == FrameType.CHALLENGE) {
                    AdvancementPlaquesToastGui.func_238463_a_((MatrixStack)matrixStack, (int)-16, (int)-16, (float)0.0f, (float)(this.height() + 32), (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                } else {
                    AdvancementPlaquesToastGui.func_238463_a_((MatrixStack)matrixStack, (int)-16, (int)-16, (float)0.0f, (float)0.0f, (int)(this.width() + 32), (int)(this.height() + 32), (int)512, (int)512);
                }
                matrixStack.func_227865_b_();
            }
            return (float)displayTime >= fadeInTime + fadeOutTime + duration ? IToast.Visibility.HIDE : IToast.Visibility.SHOW;
        }
        return IToast.Visibility.HIDE;
    }

    public boolean render(int screenWidth, int index, MatrixStack matrixStack) {
        long currentTime = Util.func_211177_b();
        if (this.animationTime == -1L) {
            this.animationTime = currentTime;
            this.visibility.func_194169_a(this.mc.func_147118_V());
        }
        if (this.visibility == IToast.Visibility.SHOW && currentTime - this.animationTime <= 200L) {
            this.visibleTime = currentTime;
        }
        RenderSystem.pushMatrix();
        RenderSystem.disableDepthTest();
        if (((Boolean)AdvancementPlaquesConfig.INSTANCE.onTop.get()).booleanValue()) {
            RenderSystem.translatef((float)((float)(this.mc.func_228018_at_().func_198107_o() - this.width()) / 2.0f), (float)((Integer)AdvancementPlaquesConfig.INSTANCE.distance.get()).intValue(), (float)(900.0f + (float)index));
        } else {
            RenderSystem.translatef((float)((float)(this.mc.func_228018_at_().func_198107_o() - this.width()) / 2.0f), (float)(this.mc.func_228018_at_().func_198087_p() - (this.height() + (Integer)AdvancementPlaquesConfig.INSTANCE.distance.get())), (float)(900.0f + (float)index));
        }
        IToast.Visibility newVisibility = this.drawPlaque(matrixStack, currentTime - this.visibleTime);
        RenderSystem.enableDepthTest();
        RenderSystem.popMatrix();
        if (newVisibility != this.visibility) {
            this.animationTime = currentTime - (long)((int)((1.0f - this.getVisibility(currentTime)) * 200.0f));
            this.visibility = newVisibility;
        }
        return this.visibility == IToast.Visibility.HIDE && currentTime - this.animationTime > 200L;
    }
}

