/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.tile.AbstractPylonTile;

public class ExpulsionPylonTile
extends AbstractPylonTile {
    private List<RegistryKey<World>> allowedDimensions = null;

    public ExpulsionPylonTile() {
        super((TileEntityType)ModRegistry.EXPULSION_PYLON_TILE.get());
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.func_77973_b() instanceof PlayerFilterCard;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.canTick(10) && this.owner != null && this.isAllowedDimension()) {
            Chunk chunk = this.field_145850_b.func_175726_f(this.field_174879_c);
            List players = Arrays.stream(chunk.func_177429_s()).map(multiMap -> multiMap.func_219790_a(ServerPlayerEntity.class)).flatMap(Collection::stream).collect(Collectors.toList());
            List<UUID> allowed = this.allowedPlayers();
            MinecraftServer server = this.field_145850_b.func_73046_m();
            for (ServerPlayerEntity player : players) {
                if (server == null || player.func_211513_k(2) || player.func_110124_au().equals(this.owner) || allowed.contains(player.func_110124_au())) continue;
                this.doRespawn(server, player);
            }
        }
    }

    @Override
    public void updateContainer(PacketBuffer packetBuffer) {
        super.updateContainer(packetBuffer);
        packetBuffer.writeBoolean(this.isAllowedDimension());
    }

    public boolean isAllowedDimension() {
        if (this.field_145850_b != null) {
            if (this.allowedDimensions == null) {
                ArrayList<RegistryKey> temp = new ArrayList<RegistryKey>();
                List allowed = (List)ConfigManager.COMMON.expulsionAllowedDimensions.get();
                for (String key : allowed) {
                    temp.add(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(key)));
                }
                this.allowedDimensions = ImmutableList.copyOf(temp);
            }
            return this.allowedDimensions.contains(this.field_145850_b.func_234923_W_());
        }
        return false;
    }

    private List<UUID> allowedPlayers() {
        ArrayList<UUID> allowed = new ArrayList<UUID>();
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            CompoundNBT tag;
            ItemStack stack = this.itemStackHandler.getStackInSlot(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof PlayerFilterCard) || (tag = stack.func_179543_a("pylons")) == null || !tag.func_186855_b("uuid")) continue;
            allowed.add(tag.func_186857_a("uuid"));
        }
        return allowed;
    }

    private void doRespawn(MinecraftServer server, ServerPlayerEntity player) {
        BlockPos respawnPosition = player.func_241140_K_();
        float respawnAngle = player.func_242109_L();
        boolean flag = player.func_241142_M_();
        ServerWorld respawnLevel = server.func_71218_a(player.func_241141_L_());
        Optional optional = respawnLevel != null && respawnPosition != null ? PlayerEntity.func_242374_a((ServerWorld)respawnLevel, (BlockPos)respawnPosition, (float)respawnAngle, (boolean)flag, (boolean)true) : Optional.empty();
        ServerWorld actualLevel = respawnLevel != null && optional.isPresent() ? respawnLevel : server.func_241755_D_();
        PlayerInteractionManager manager = new PlayerInteractionManager(actualLevel);
        ServerPlayerEntity dummyPlayer = new ServerPlayerEntity(server, actualLevel, player.func_146103_bH(), manager);
        if (optional.isPresent()) {
            float actualAngle;
            if (this.sameChunk((World)actualLevel, dummyPlayer.func_233580_cy_())) {
                return;
            }
            BlockState blockstate = actualLevel.func_180495_p(respawnPosition);
            boolean isAnchor = blockstate.func_203425_a(Blocks.field_235400_nj_);
            Vector3d spawnPos = (Vector3d)optional.get();
            if (!blockstate.func_235714_a_((ITag)BlockTags.field_219747_F) && !isAnchor) {
                actualAngle = respawnAngle;
            } else {
                Vector3d vector3d = Vector3d.func_237492_c_((Vector3i)respawnPosition).func_178788_d(spawnPos).func_72432_b();
                actualAngle = (float)MathHelper.func_76138_g((double)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875 - 90.0));
            }
            dummyPlayer.func_70012_b(spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, actualAngle, 0.0f);
        } else if (this.sameChunk((World)actualLevel, actualLevel.func_241135_u_())) {
            return;
        }
        while (!actualLevel.func_226669_j_((Entity)dummyPlayer) && dummyPlayer.func_226278_cu_() < 256.0) {
            dummyPlayer.func_70107_b(dummyPlayer.func_226277_ct_(), dummyPlayer.func_226278_cu_() + 1.0, dummyPlayer.func_226281_cx_());
        }
        player.func_200619_a(actualLevel, dummyPlayer.func_226277_ct_(), dummyPlayer.func_226278_cu_(), dummyPlayer.func_226281_cx_(), dummyPlayer.field_70177_z, dummyPlayer.field_70125_A);
    }

    private boolean sameChunk(World world, BlockPos target) {
        if (this.field_145850_b != null && this.field_145850_b.func_234923_W_() == world.func_234923_W_()) {
            int thisX = this.field_174879_c.func_177958_n() >> 4;
            int thisZ = this.field_174879_c.func_177952_p() >> 4;
            int thatX = target.func_177958_n() >> 4;
            int thatZ = target.func_177952_p() >> 4;
            return thisX == thatX && thisZ == thatZ;
        }
        return false;
    }
}

