/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.tile;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPylonTile
extends TileEntity
implements ITickableTileEntity {
    public static final int SLOTS = 9;
    protected final ItemStackHandler itemStackHandler = new PylonItemStackHandler(9){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return AbstractPylonTile.this.isItemValid(stack);
        }
    };
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemStackHandler);
    protected UUID owner = null;
    protected String ownerName = null;
    private long lastTicked = 0L;

    protected AbstractPylonTile(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    protected abstract boolean isItemValid(ItemStack var1);

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void dropItems() {
        AbstractPylonTile.dropItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.itemStackHandler);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.handler.invalidate();
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public boolean canTick(int every) {
        long gameTime;
        long l = gameTime = this.field_145850_b != null ? this.field_145850_b.func_82737_E() : 0L;
        if (gameTime % (long)every == 0L && gameTime != this.lastTicked) {
            this.lastTicked = gameTime;
            return true;
        }
        return false;
    }

    protected static void dropItems(@Nullable World world, BlockPos pos, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemstack = itemHandler.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0 || world == null) continue;
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    public void updateContainer(PacketBuffer packetBuffer) {
        String lastKnown = UsernameCache.getLastKnownUsername((UUID)this.owner);
        String username = StringUtils.defaultString((String)lastKnown, (String)"unknown");
        packetBuffer.func_179255_a(this.field_174879_c);
        packetBuffer.writeInt(username.length());
        packetBuffer.func_180714_a(username);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.itemStackHandler.serializeNBT());
        this.writeOwner(tag);
        return super.func_189515_b(tag);
    }

    private void writeOwner(CompoundNBT tag) {
        if (this.owner != null) {
            tag.func_186854_a("owner", this.owner);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.itemStackHandler.deserializeNBT(tag.func_74775_l("inv"));
        this.readOwner(tag);
        super.func_230337_a_(state, tag);
    }

    private void readOwner(CompoundNBT tag) {
        if (tag.func_186855_b("owner")) {
            this.owner = tag.func_186857_a("owner");
        }
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        this.writeOwner(tag);
        return tag;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readOwner(tag);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_195044_w(), pkt.func_148857_g());
    }

    public class PylonEnergyStorage
    extends EnergyStorage
    implements INBTSerializable<CompoundNBT> {
        public PylonEnergyStorage(int capacity, int maxTransfer) {
            super(capacity, maxTransfer);
        }

        public void onEnergyChanged() {
            AbstractPylonTile.this.func_70296_d();
        }

        public void setEnergy(int energy) {
            this.energy = energy;
            this.onEnergyChanged();
        }

        public void addEnergy(int energy) {
            this.energy += energy;
            if (this.energy > this.getMaxEnergyStored()) {
                this.energy = this.getEnergyStored();
            }
            this.onEnergyChanged();
        }

        public void consumeEnergy(int energy) {
            this.energy -= energy;
            if (this.energy < 0) {
                this.energy = 0;
            }
            this.onEnergyChanged();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("energy", this.getEnergyStored());
            return tag;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            this.setEnergy(nbt.func_74762_e("energy"));
        }
    }

    public class PylonItemStackHandler
    extends ItemStackHandler {
        public PylonItemStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            AbstractPylonTile.this.func_70296_d();
        }
    }
}

