/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.permutated.pylons.ConfigManager;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.util.TranslationKey;

public class PotionFilterCard
extends Item {
    public static final int MINIMUM = (Integer)ConfigManager.COMMON.infusionMinimumDuration.get() * 20;
    public static final int REQUIRED = (Integer)ConfigManager.COMMON.infusionRequiredDuration.get() * 20;

    public PotionFilterCard() {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ModRegistry.CREATIVE_TAB).setNoRepair());
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof PotionFilterCard) {
            if (!level.field_72995_K) {
                Effect effect = PotionFilterCard.getEffect(stack);
                int amplifier = PotionFilterCard.getAmplifier(stack);
                int duration = PotionFilterCard.getDuration(stack);
                if (duration >= REQUIRED) {
                    return ActionResult.func_226248_a_((Object)stack);
                }
                Optional<EffectInstance> active = effect == null ? player.func_70651_bq().stream().filter(effectInstance -> effectInstance.func_76459_b() >= MINIMUM).findFirst() : player.func_70651_bq().stream().filter(effectInstance -> effectInstance.func_76459_b() >= MINIMUM).filter(effectInstance -> Objects.equals(effectInstance.func_188419_a(), effect)).filter(effectInstance -> Objects.equals(effectInstance.func_76458_c(), amplifier)).findFirst();
                if (active.isPresent()) {
                    Effect activeEffect = active.get().func_188419_a();
                    int activeAmplifier = active.get().func_76458_c();
                    int activeDuration = active.get().func_76459_b();
                    ItemStack copy = effect == null ? PotionFilterCard.withEffect(stack, activeEffect, activeAmplifier, activeDuration) : PotionFilterCard.addDuration(stack, activeDuration);
                    player.func_195063_d(activeEffect);
                    return ActionResult.func_226248_a_((Object)copy);
                }
            } else {
                return ActionResult.func_226249_b_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("pylons");
        return tag != null && tag.func_74764_b("effect");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        int display;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        Effect effect = PotionFilterCard.getEffect(stack);
        int duration = PotionFilterCard.getDuration(stack);
        int amplifier = PotionFilterCard.getAmplifier(stack);
        int n = display = duration < 20 ? 0 : duration / 20;
        if (effect != null) {
            IFormattableTextComponent component = effect.func_199286_c().func_230532_e_();
            if (amplifier > 0) {
                component = this.withAmplifier(component, amplifier);
            }
            if (effect.func_188408_i()) {
                tooltip.add((ITextComponent)component.func_240699_a_(TextFormatting.BLUE));
            } else {
                tooltip.add((ITextComponent)component.func_240699_a_(TextFormatting.RED));
            }
            tooltip.add((ITextComponent)new StringTextComponent(""));
            if (duration >= REQUIRED) {
                tooltip.add((ITextComponent)this.translate("insert1"));
                tooltip.add((ITextComponent)this.translate("insert2"));
                tooltip.add((ITextComponent)this.translate("activated").func_240699_a_(TextFormatting.GREEN));
            } else {
                tooltip.add((ITextComponent)this.translate("increase1"));
                tooltip.add((ITextComponent)this.translate("increase2"));
                tooltip.add((ITextComponent)this.translate("progress", display, REQUIRED / 20).func_240699_a_(TextFormatting.RED));
            }
        } else {
            tooltip.add((ITextComponent)this.translate("no_effect1"));
            tooltip.add((ITextComponent)this.translate("no_effect2"));
            tooltip.add((ITextComponent)this.translate("minimum_duration", MINIMUM / 20));
        }
    }

    public static ItemStack withEffect(ItemStack stack, Effect effect, int amplifier, int duration) {
        ResourceLocation registryName = effect.getRegistryName();
        if (registryName == null) {
            return stack;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("effect", registryName.toString());
        tag.func_74768_a("amplifier", amplifier);
        tag.func_74768_a("duration", Math.min(REQUIRED, duration));
        ItemStack copy = stack.func_77946_l();
        copy.func_77983_a("pylons", (INBT)tag);
        return copy;
    }

    public static ItemStack addDuration(ItemStack stack, int duration) {
        ItemStack copy = stack.func_77946_l();
        CompoundNBT tag = copy.func_190925_c("pylons");
        int current = tag.func_74762_e("duration");
        if (current >= REQUIRED) {
            return stack;
        }
        int total = Math.min(REQUIRED, current + duration);
        tag.func_74768_a("duration", total);
        return copy;
    }

    @Nullable
    public static Effect getEffect(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("pylons");
        if (tag != null && tag.func_74764_b("effect")) {
            String effectName = tag.func_74779_i("effect");
            return (Effect)ForgeRegistries.POTIONS.getValue(new ResourceLocation(effectName));
        }
        return null;
    }

    public static int getDuration(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("pylons");
        if (tag != null && tag.func_74764_b("duration")) {
            return tag.func_74762_e("duration");
        }
        return 0;
    }

    public static int getAmplifier(ItemStack stack) {
        CompoundNBT tag = stack.func_179543_a("pylons");
        if (tag != null && tag.func_74764_b("amplifier")) {
            return tag.func_74762_e("amplifier");
        }
        return 0;
    }

    protected IFormattableTextComponent translate(String key) {
        return new TranslationTextComponent(TranslationKey.tooltip(key)).func_240699_a_(TextFormatting.GRAY);
    }

    protected TranslationTextComponent translate(String key, Object ... values) {
        return new TranslationTextComponent(TranslationKey.tooltip(key), values);
    }

    protected TranslationTextComponent withAmplifier(IFormattableTextComponent component, int amplifier) {
        return new TranslationTextComponent("potion.withAmplifier", new Object[]{component, new TranslationTextComponent("potion.potency." + amplifier)});
    }
}

