/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.block;

import io.netty.buffer.Unpooled;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.inventory.container.AbstractPylonContainer;
import net.permutated.pylons.tile.AbstractPylonTile;
import net.permutated.pylons.util.TranslationKey;

public abstract class AbstractPylonBlock
extends Block {
    private static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    protected AbstractPylonBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).func_200948_a(2.0f, 1200.0f));
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract TileEntity createTileEntity(BlockState var1, IBlockReader var2);

    public abstract IContainerFactory<AbstractPylonContainer> containerFactory();

    public void func_180633_a(World level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        TileEntity tileEntity;
        if (!level.field_72995_K && entity instanceof PlayerEntity && (tileEntity = level.func_175625_s(blockPos)) instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            pylonTile.setOwner(entity.func_110124_au());
        }
    }

    public void func_176206_d(IWorld world, BlockPos blockPos, BlockState blockState) {
        Optional.ofNullable(world.func_175625_s(blockPos)).map(AbstractPylonTile.class::cast).ifPresent(AbstractPylonTile::dropItems);
        super.func_176206_d(world, blockPos, blockState);
    }

    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        TileEntity tileEntity;
        if (event.getPlayer().func_211513_k(2)) {
            return;
        }
        if (event.getState().func_177230_c() instanceof AbstractPylonBlock && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof AbstractPylonTile) {
            AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            if (!event.getPlayer().func_110124_au().equals(pylonTile.getOwner())) {
                event.setCanceled(true);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof AbstractPylonTile) {
                ((AbstractPylonTile)tileentity).dropItems();
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) return ActionResultType.SUCCESS;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof AbstractPylonTile) {
            final AbstractPylonTile pylonTile = (AbstractPylonTile)tileEntity;
            INamedContainerProvider containerProvider = new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent(AbstractPylonBlock.this.func_149739_a());
                }

                public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                    PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                    pylonTile.updateContainer(buffer);
                    return AbstractPylonBlock.this.containerFactory().create(i, playerInventory, buffer);
                }
            };
            if (!player.func_110124_au().equals(pylonTile.getOwner())) {
                if (!player.func_211513_k(2)) return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, pylonTile::updateContainer);
            return ActionResultType.SUCCESS;
        } else {
            Pylons.LOGGER.error("tile entity not instance of AbstractPylonTile");
            return ActionResultType.FAIL;
        }
    }

    protected IFormattableTextComponent translate(String key) {
        return new TranslationTextComponent(TranslationKey.tooltip(key)).func_240699_a_(TextFormatting.GRAY);
    }
}

