/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.permutated.pylons.block.ExpulsionPylonBlock;
import net.permutated.pylons.block.InfusionPylonBlock;
import net.permutated.pylons.inventory.container.ExpulsionPylonContainer;
import net.permutated.pylons.inventory.container.InfusionPylonContainer;
import net.permutated.pylons.item.PlayerFilterCard;
import net.permutated.pylons.item.PotionFilterCard;
import net.permutated.pylons.tile.AbstractPylonTile;
import net.permutated.pylons.tile.ExpulsionPylonTile;
import net.permutated.pylons.tile.InfusionPylonTile;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"pylons");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"pylons");
    public static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"pylons");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"pylons");
    public static final ItemGroup CREATIVE_TAB = new ModItemGroup("pylons", () -> new ItemStack((IItemProvider)PLAYER_FILTER.get()));
    public static final RegistryObject<Item> PLAYER_FILTER = ITEMS.register("player_filter", PlayerFilterCard::new);
    public static final RegistryObject<Item> POTION_FILTER = ITEMS.register("potion_filter", PotionFilterCard::new);
    public static final RegistryObject<Block> EXPULSION_PYLON = BLOCKS.register("expulsion_pylon", ExpulsionPylonBlock::new);
    public static final RegistryObject<Block> INFUSION_PYLON = BLOCKS.register("infusion_pylon", InfusionPylonBlock::new);
    public static final RegistryObject<BlockItem> EXPULSION_PYLON_ITEM = ModRegistry.blockItem(EXPULSION_PYLON);
    public static final RegistryObject<BlockItem> INFUSION_PYLON_ITEM = ModRegistry.blockItem(INFUSION_PYLON);
    public static final RegistryObject<TileEntityType<ExpulsionPylonTile>> EXPULSION_PYLON_TILE = ModRegistry.tile(EXPULSION_PYLON, ExpulsionPylonTile::new);
    public static final RegistryObject<TileEntityType<InfusionPylonTile>> INFUSION_PYLON_TILE = ModRegistry.tile(INFUSION_PYLON, InfusionPylonTile::new);
    public static final RegistryObject<ContainerType<ExpulsionPylonContainer>> EXPULSION_PYLON_CONTAINER = ModRegistry.container("expulsion_pylon", ExpulsionPylonContainer::new);
    public static final RegistryObject<ContainerType<InfusionPylonContainer>> INFUSION_PYLON_CONTAINER = ModRegistry.container("infusion_pylon", InfusionPylonContainer::new);
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static RegistryObject<BlockItem> blockItem(RegistryObject<Block> registryObject) {
        return ITEMS.register(registryObject.getId().func_110623_a(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties().func_200916_a(CREATIVE_TAB)));
    }

    private static RegistryObject<Item> material(String path) {
        return ITEMS.register(path, () -> new Item(new Item.Properties().func_200916_a(CREATIVE_TAB)));
    }

    private static <T extends AbstractPylonTile> RegistryObject<TileEntityType<T>> tile(RegistryObject<Block> registryObject, Supplier<T> supplier) {
        return TILES.register(registryObject.getId().func_110623_a(), () -> TileEntityType.Builder.func_223042_a((Supplier)supplier, (Block[])new Block[]{(Block)registryObject.get()}).func_206865_a(EMPTY_PART));
    }

    private static <T extends Container> RegistryObject<ContainerType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IForgeContainerType.create((IContainerFactory)supplier));
    }

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
    }

    public static final class ModItemGroup
    extends ItemGroup {
        private final Supplier<ItemStack> iconSupplier;

        public ModItemGroup(String name, Supplier<ItemStack> iconSupplier) {
            super(name);
            this.iconSupplier = iconSupplier;
        }

        @Nonnull
        public ItemStack func_78016_d() {
            return this.iconSupplier.get();
        }
    }
}

