/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber
public class ConfigManager {
    public static final String CATEGORY_EXPULSION = "expulsion_pylon";
    public static final String CATEGORY_INFUSION = "infusion_pylon";
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    private ConfigManager() {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> expulsionAllowedDimensions;
        public final ForgeConfigSpec.IntValue infusionMinimumDuration;
        public final ForgeConfigSpec.IntValue infusionRequiredDuration;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push(ConfigManager.CATEGORY_EXPULSION);
            this.expulsionAllowedDimensions = builder.comment("Which dimensions the Expulsion Pylon is allowed to operate in.").defineList("expulsionAllowedDimensions", (List)ImmutableList.of((Object)"minecraft:overworld"), s -> s instanceof String && ((String)s).matches("^\\w+:\\w+$"));
            builder.pop();
            builder.push(ConfigManager.CATEGORY_INFUSION);
            this.infusionMinimumDuration = builder.comment(new String[]{"The minimum effect duration (in seconds) that can be used for Potion Filters.", "This defaults to 60 seconds to prevent unintended interactions", "with other mods that add persistent potion effects at low durations."}).defineInRange("infusionMinimumDuration", 60, 1, 3600);
            this.infusionRequiredDuration = builder.comment(new String[]{"The total duration (in seconds) required before a Potion Filter can be used.", "By default this is 3600 seconds/1 hour, which is equivalent to 7.5 vanilla extended potions."}).defineInRange("infusionRequiredDuration", 3600, 1, 28800);
            builder.pop();
        }
    }
}

