/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import com.google.common.collect.ImmutableMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.block.Furnace;
import xiroc.dungeoncrawl.dungeon.block.Plants;
import xiroc.dungeoncrawl.dungeon.block.Spawner;
import xiroc.dungeoncrawl.theme.SecondaryTheme;
import xiroc.dungeoncrawl.theme.Theme;

public interface IBlockPlacementHandler {
    public static final IBlockPlacementHandler SPAWNER = new Spawner();
    public static final IBlockPlacementHandler DEFAULT = (world, state, pos, rand, theme, secondaryTheme, lootLevel, worldGen) -> {
        if (((Boolean)Config.TICK_FALLING_BLOCKS.get()).booleanValue() && state.func_177230_c() instanceof FallingBlock) {
            world.func_217349_x(pos).func_205218_i_().func_205360_a(pos, (Object)state.func_177230_c(), 1);
        }
        world.func_180501_a(pos, state, 2);
    };
    public static final ImmutableMap<Block, IBlockPlacementHandler> PLACEMENT_HANDLERS = new ImmutableMap.Builder().put((Object)Blocks.field_150460_al, (Object)new Furnace()).put((Object)Blocks.field_222423_lL, (Object)new Furnace.Smoker()).put((Object)Blocks.field_150474_ac, (Object)SPAWNER).put((Object)Blocks.field_150458_ak, (Object)new Plants.Farmland()).put((Object)Blocks.field_150457_bL, (Object)new Plants.FlowerPot()).put((Object)Blocks.field_196661_l, (Object)new Plants.Podzol()).build();

    public void place(IWorld var1, BlockState var2, BlockPos var3, Random var4, Theme var5, SecondaryTheme var6, int var7, boolean var8);

    public static IBlockPlacementHandler getHandler(Block block) {
        return (IBlockPlacementHandler)PLACEMENT_HANDLERS.getOrDefault((Object)block, (Object)DEFAULT);
    }
}

